<!DOCTYPE html>
<html lang="en">
<head>
  <title>Evason Profumo</title>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="format-detection" content="telephone=no">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="author" content="">
  <meta name="keywords" content="">
  <meta name="description" content="">
</head>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/icomoon/icomoon.css">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet"
  integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/vendor.css">
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/style.css">

<link rel="preconnect" href="https://fonts.googleapis.com/">
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
<link
  href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&amp;family=Lustria&amp;display=swap"
  rel="stylesheet">
  
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  
  <style>
      .img-fluid {
          border-radius: 25px;
      }
  </style>
</head>

<body>

   <div class="preloader-wrapper">
    <div class="preloader">
    </div>
  </div> 

  <?php include("header.php"); ?>

  <section id="hero">
    <div class="swiper slideshow">
      <div class="swiper-wrapper">
          <?php foreach($banner as $bannerrow): ?>
        <div class="swiper-slide" style="background-image:url(<?= base_url() ?>uploads/banner/<?= esc($bannerrow['image']) ?>);">
          <div class="container padding-large">
            <div class="row justify-content-start">
              <div class="col-lg-6" data-aos="fade-up">
                <h2 class="display-1 text-uppercase text-white mt-3"><?= esc($bannerrow['maintitle']) ?></h2>
                <p class="text-capitalize text-white fs-5 mb-4"><?= esc($bannerrow['subtitle']) ?></p>
                <a href="<?php echo base_url('products'); ?>" class="btn btn-light">
                  Expore More
                </a>
              </div>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      </div>
      <div class="swiper-pagination swiper-pagination-slideshow"></div>
    </div>
  </section>

  <section class="logo-bar">
    <div class="container padding-medium" data-aos="fade-up">
      <div class="row ">
        <div class="logo-content d-flex flex-wrap justify-content-between">
          <a href="#"> <img src="<?= base_url() ?>public/images/logo1.png" alt="logo" class="logo-image img-fluid my-3"> </a>
          <a href="#"> <img src="<?= base_url() ?>public/images/logo2.png" alt="logo" class="logo-image img-fluid my-3"> </a>
          <a href="#"> <img src="<?= base_url() ?>public/images/logo3.png" alt="logo" class="logo-image img-fluid my-3"> </a>
          <a href="#"> <img src="<?= base_url() ?>public/images/logo4.png" alt="logo" class="logo-image img-fluid my-3"> </a>
          <a href="#"> <img src="<?= base_url() ?>public/images/logo5.png" alt="logo" class="logo-image img-fluid my-3"> </a>
        </div>
      </div>
    </div>
  </section>

  <!--<section id="category">-->
  <!--  <div class="container-fluid px-3 px-md-5">-->
  <!--    <div class="row">-->
  <!--      <div class="col-md-4 position-relative" data-aos="fade-up" data-aos-delay="300">-->
  <!--        <div class="z-1 position-absolute bottom-0 start-0 m-3 m-lg-5 ps-4 text-white">-->
  <!--          <h3 class="text-light text-uppercase">Skincare Essentials</h3>-->
  <!--        </div>-->
  <!--        <div class="image-holder zoom-effect">-->
  <!--          <a href="single-post.html">-->
  <!--            <img src="<?= base_url() ?>public/images/category1.jpg" alt="Luxury skincare products" class="post-image img-fluid">-->
  <!--          </a>-->
  <!--        </div>-->
  <!--      </div>-->
  <!--      <div class="col-md-4 position-relative" data-aos="fade-up" data-aos-delay="600">-->
  <!--        <div class="z-1 position-absolute bottom-0 start-0 m-3 m-lg-5 ps-4 text-white">-->
  <!--          <h3 class="text-light text-uppercase">Makeup Collection</h3>-->
  <!--        </div>-->
  <!--        <div class="image-holder zoom-effect">-->
  <!--          <a href="single-post.html">-->
  <!--            <img src="<?= base_url() ?>public/images/category3.jpg" alt="Premium makeup products" class="post-image img-fluid">-->
  <!--          </a>-->
  <!--        </div>-->
  <!--      </div>-->
  <!--      <div class="col-md-4 position-relative" data-aos="fade-up" data-aos-delay="900">-->
  <!--        <div class="z-1 position-absolute bottom-0 start-0 m-3 m-lg-5 ps-4 text-white">-->
  <!--          <h3 class="text-light text-uppercase">Fragrance & Scents</h3>-->
  <!--        </div>-->
  <!--        <div class="image-holder zoom-effect">-->
  <!--          <a href="single-post.html">-->
  <!--            <img src="<?= base_url() ?>public/images/category2.jpg" alt="Luxury perfume bottles" class="post-image img-fluid">-->
  <!--          </a>-->
  <!--        </div>-->
  <!--      </div>-->
  <!--    </div>-->
  <!--  </div>-->
  <!--</section>-->
  
    <section class="">
        <div class="container">
            <div class="row align-items-center g-md-5">
              <div class="col-md-6">
                <img src="public/images/Service-1.webp" alt="img" class="img-fluid">
            
              </div>
              <div class="col-md-6 mt-5">
                <h2 class="">About Evason Profumo</h2>
                <p>Evason Profumo is a luxury fragrance brand proudly born in Nigeria, under Evason Cosmetics. Established with a passion for excellence, the brand brings African creativity and global sophistication together - offering an exquisite collection of perfumes for men and women.</p>
            
                <p>Evason Profumo captures individuality, confidence, and allure in every bottle.</p>
            
                <a href="<?php echo base_url('about'); ?>" class="btn btn-primary py-3 px-5 mt-4">
                  Know More</a>
            
            
              </div>
            </div>
        </div>
    </section>
    <section class="">
        <div class="container padding-medium">
            <div class="row align-items-center g-md-5">
              
              <div class="col-md-6 mt-5">
                <h2 class="">Our Essence </h2>
                <p>At Evason Profumo, every fragrance tells a story - crafted with precision, artistry, and emotion. We source the finest raw ingredients from around the world, blending them through advanced distillation and formulation processes to achieve signature scents that stand out for their quality and longevity.</p>
            
                <p>Our fragrances vary in all genres and a perfect  balance that defines the true spirit of luxury. Evason Profumo perfumes are known for extensive longevity offering a lasting impression of refinement and confidence.</p>
            
            
              </div>
              <div class="col-md-6">
                <img src="public/images/about1_1.webp" alt="img" class="img-fluid">
            
              </div>
            </div>
        </div>
    </section>

  <section id="new-arrival" class="product-store" style="padding-bottom: 75px;">
    <div class="container" data-aos="fade-up">
      <div class="section-header d-md-flex justify-content-between align-items-center mb-3">
        <h2 class="display-5 fw-light text-uppercase">Our Products</h2>
        <div>
          <a href="<?php echo base_url('products'); ?>" class="btn btn-primary">
            View All</a>
        </div>
      </div>
      <div class="row">
      	<?php if(!empty($products)): ?>
        <?php foreach($products as $p): ?>
        <div class="col-md-6 col-lg-3 my-4">
          <div class="product-item position-relative">
            <div class="image-holder">
            	<?php if($p['image']): ?>
                <img src="<?= base_url('uploads/products/'.$p['image']) ?>" class="card-img-top" alt="<?= esc($p['name']) ?>" alt="Books" class="product-image img-fluid">
              <?php else: ?>
                <img src="<?= base_url('uploads/no-image.png') ?>" class="card-img-top" alt="No image">
              <?php endif; ?>
             
            </div>
            <div class="cart-concern">
              <div class="cart-button d-flex justify-content-between align-items-center">
                <a href="<?= site_url('product/'.$p['slug']) ?>" class="btn-wrap cart-link align-items-center text-capitalize">Explore More <i
                    class="icon icon-arrow-io pe-1"></i>
                </a>
              </div>
            </div>
            <div class="product-detail d-flex justify-content-between align-items-center mt-2">
              <a href="<?= base_url('product/'.$p['slug']) ?>">
                <h5 class="product-title mb-0 text-black"> <?= esc($p['name']) ?> </h5>
              </a>
              <p class="m-0 fs-5 fw-normal text-black"><?= esc($p['price']) ?></p>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      <?php else: ?>
        <p class="text-center">No products available.</p>
      <?php endif; ?>
      </div>
    </div>
  </section>

  
    <section id="register"
    style="background-image:url(<?= base_url() ?>public/images/background-img.jpg); background-repeat: no-repeat; background-position: center;">
    <div class="container padding-medium" data-aos="fade-up">
      <div class="row banner-content justify-content-center align-items-center">
        <div class="col-md-6">
          <h2 class="display-2 text-black">Get <span> <em>20% OFF</em> </span> on your first purchase</h2>
          <p class="m-0 text-black">Sign Up for our newsletter and never miss any offers</p>
        </div>
        <div class="col-md-4">
          <form>
            <div class="mb-3">
              <input type="email" class="form-control form-control-lg rounded-3 text-center bg-light" name="email"
                id="email" placeholder="Enter Your Email Address">
            </div>
            <div class="d-grid gap-2">
              <button type="submit" class="btn btn-primary btn-lg rounded-3">Register now</button>
            </div>
          </form>
        </div>

      </div>
    </div>
  </section>
  

  <div id="blog" class="padding-medium">
    <div class="container" data-aos="fade-up">
      <div class="section-header d-md-flex justify-content-between align-items-center mb-3">
        <h2 class="display-5 fw-light text-uppercase">Recent Blog Post</h2>
        <div>
          <a href="<?php echo base_url('blogs'); ?>" class="btn btn-primary">
            Read All</a>
        </div>
      </div>
      <div class="row">
          <?php if(!empty($blogs)): ?>
        <?php foreach($blogs as $b): ?>
        <div class="col-md-4 my-4" data-aos="fade-up" data-aos-delay="300">
          <div class="card position-relative">
            <div class="z-1 position-absolute m-2 px-3 pt-1">
              <h2 class="text-light display-4 m-0">20<span class="fs-4">MAR</span> </h2>
            </div>
            <a href="<?= base_url('blog/'.$b['slug']) ?>"><img src="<?= base_url('uploads/blogs/'.$b['image']) ?>" class="img-fluid" alt="Summer skincare routine"></a>
            <div class="card-body p-0">
              <a href="<?= base_url('blog/'.$b['slug']) ?>">
                <h3 class="pt-4 pb-3 m-0 text-black"><?= esc($b['title']) ?></h3>
              </a>
              <div class="card-text">
                <p><?= esc($b['summary']) ?></p>
              </div>
            </div>
          </div>
        </div>
       <?php endforeach; ?>
      <?php else: ?>
        <p class="text-center"></p>
      <?php endif; ?>
        
      </div>
    </div>
  </div>
  
  <section class="testimonials bg-primary padding-medium"
    style="background-image:url(<?= base_url() ?>public/images/background-img1.jpg); background-repeat: no-repeat; background-position: center;">
    <div class="swiper testimonial-swiper overflow-hidden" data-aos="fade-up">
      <div class="swiper-wrapper d-flex">
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <blockquote>
              <p>“This skincare serum completely transformed my complexion. My skin has never felt more hydrated and
                radiant!”</p>
              <div class="review-title mt-3 text-uppercase text-center">- Glowing Results</div>
            </blockquote>
          </div>
        </div>
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <blockquote>
              <p>“The foundation provides perfect coverage while feeling lightweight. It's become my daily essential.”
              </p>
              <div class="review-title mt-3 text-uppercase text-center">- Sophia</div>
            </blockquote>
          </div>
        </div>
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <blockquote>
              <p>“The fragrance lasts all day and I constantly receive compliments. Absolutely worth every penny!”</p>
              <div class="review-title mt-3 text-uppercase text-center">- Signature Scent</div>
            </blockquote>
          </div>
        </div>
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <blockquote>
              <p>“These products are cruelty-free and actually deliver visible results. My new beauty ritual!”</p>
              <div class="review-title mt-3 text-uppercase text-center">- Emma</div>
            </blockquote>
          </div>
        </div>
      </div>
    </div>
  </section>
  
  

  <?php include("footer.php"); ?>

  <script src="<?= base_url() ?>public/js/jquery-1.11.0.min.js"></script>
  <script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/swiper%409/swiper-bundle.min.js"></script>
  <script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/bootstrap%405.3.0-alpha3/dist/js/bootstrap.bundle.min.js"
    integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe"
    crossorigin="anonymous"></script>
  <script src="<?= base_url() ?>public/js/plugins.js"></script>
  <script src="<?= base_url() ?>public/js/script.js"></script>
  <script src="<?= base_url() ?>public/code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
</body>

</html>