<!DOCTYPE html>
<html lang="en">

<head>
 <title>Evason Profumo</title>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="format-detection" content="telephone=no">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="author" content="">
  <meta name="keywords" content="">
  <meta name="description" content="">
</head>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/icomoon/icomoon.css">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet"
  integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/vendor.css">
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/style.css">

<link rel="preconnect" href="https://fonts.googleapis.com/">
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&amp;family=Lustria&amp;display=swap" rel="stylesheet">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

  <style>
       .sub-banner {
    margin-top: 96px;
}

.breadcrumb a {
    font-size: 16px !important;
}

.breadcrumb-item .active {
    font-size: 16px !important;
}
  </style>
</head>

<body>

    <div class="preloader-wrapper">
        <div class="preloader"></div>
    </div>

    <?php include("header.php"); ?>

    <section class="sub-banner" id="banner">
        <div class="container">
            <div class="hero-content text-center">
                <h2 class="text-uppercase text-light mt-5 mb-0">Products</h2>
                <nav class="breadcrumb d-flex justify-content-center">
                    <a class="breadcrumb-item nav-link" href="<?php echo base_url(); ?>">Home</a>
                    <span class="breadcrumb-item active" aria-current="page">Products</span>
                </nav>
            </div>
        </div>
    </section>

    <section id="shop">
        <div class="container padding-normal">
            <div class="row flex-md-row-reverse g-md-5 mb-5">
                <main class="col-md-12 product-store">
                    <div class="row">
                    <?php if(!empty($products)): ?>
                    <?php foreach($products as $p): ?>
                    <div class="col-md-6 col-lg-4 my-4">
                        <div class="product-item">
                            <div class="image-holder" style="width: 100%; height: 100%;">
                                <?php if($p['image']): ?>
                                <img src="<?= base_url('uploads/products/'.$p['image']) ?>" class="card-img-top" alt="<?= esc($p['name']) ?>" alt="Books" class="product-image img-fluid">
                                <?php else: ?>
                                <img src="<?= base_url('uploads/no-image.png') ?>" class="card-img-top" alt="No image">
                                <?php endif; ?>
                            </div>
                            <div class="cart-concern">
                                <div class="cart-button d-flex justify-content-between align-items-center">
                                    <a href="<?= base_url('product/'.$p['slug']) ?>" class="btn-wrap cart-link d-flex align-items-center text-capitalize fs-6 ">Explore More
                                      <i class="icon icon-arrow-io pe-1"></i>
                                    </a>
                                    <a href="<?= base_url('product/'.$p['slug']) ?>" class="view-btn mt-1">
                                      <i class="icon icon-screen-full"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="product-detail d-flex justify-content-between align-items-center mt-2">
                                <a href="<?= base_url('product/'.$p['slug']) ?>">
                                <h5 class="product-title text-black mb-0">
                                  <?= esc($p['name']) ?>
                                </h5>
                                </a>
                                <p class="m-0 fs-5 fw-normal text-black"><?= esc($p['price']) ?></p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                    <?php else: ?>
                      <p class="text-center">No products available.</p>
                    <?php endif; ?>
                </div>
        
            </main>
            
        </div>
    </div>
</section>

  <?php include("footer.php"); ?>


  <script src="<?= base_url() ?>public/js/jquery-1.11.0.min.js"></script>
  <script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/swiper%409/swiper-bundle.min.js"></script>
  <script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/bootstrap%405.3.0-alpha3/dist/js/bootstrap.bundle.min.js"
    integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe"
    crossorigin="anonymous"></script>
  <script src="<?= base_url() ?>public/js/plugins.js"></script>
  <script src="<?= base_url() ?>public/js/script.js"></script>
  <script src="../../code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
</body>

</html>