<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\AboutModel;

class About extends BaseController
{
    public function index()
    {
        $model = new AboutModel();
        $data['about'] = $model->findAll();
        return view('admin/about/index', $data);
    }

    public function create()
    {
        return view('admin/about/create');
    }

    public function store()
    {
        $model = new AboutModel();

        // ---- Single thumbnail ----
        $imageName = null;
        $thumbnail = $this->request->getFile('aboutimage');
        if ($thumbnail && $thumbnail->isValid() && !$thumbnail->hasMoved()) {
            $imageName = $thumbnail->getRandomName();
            $thumbnail->move('uploads/about', $imageName);
        }
        
        // ---- Single thumbnail ----
        $imageNamee = null;
        $thumbnaill = $this->request->getFile('image');
        if ($thumbnaill && $thumbnaill->isValid() && !$thumbnaill->hasMoved()) {
            $imageNamee = $thumbnaill->getRandomName();
            $thumbnaill->move('uploads/about', $imageNamee);
        }

        // ---- Insert data ----
        $model->insert([
            'about'        => $this->request->getPost('about'),
            'aboutimage' => $imageName,
            'mission'       => $this->request->getPost('mission'),
            'vision'       => $this->request->getPost('vision'),
            'objective'       => $this->request->getPost('objective'),
            'message'       => $this->request->getPost('objective'),
            'image'       => $imageNamee,
            'mfrom'         => $this->request->getPost('mfrom'),
            'designation'   => $this->request->getPost('designation'),
        ]);

        return redirect()->to(base_url('admin/about'))->with('success', 'About added successfully!');
    }

    public function edit($id)
    {
        $model = new AboutModel();
        $data['about'] = $model->find($id);

        return view('admin/about/edit', $data);
    }

    public function update($id)
    {
        $model = new AboutModel();
        $about = $model->find($id);

        // ---- Single thumbnail update ----
        $imageName = $about['aboutimage'];
        $img = $this->request->getFile('aboutimage');
        if ($img && $img->isValid() && !$img->hasMoved()) {
            if ($imageName && file_exists('uploads/about/' . $imageName)) {
                unlink('uploads/about/' . $imageName);
            }
            $imageName = $img->getRandomName();
            $img->move('uploads/about', $imageName);
        }

        // ---- Single thumbnail update ----
        $imageNamee = $about['image'];
        $img = $this->request->getFile('image');
        if ($img && $img->isValid() && !$img->hasMoved()) {
            if ($imageNamee && file_exists('uploads/about/' . $imageNamee)) {
                unlink('uploads/about/' . $imageNamee);
            }
            $imageNamee = $img->getRandomName();
            $img->move('uploads/about', $imageNamee);
        }

        $model->update($id, [
            'about'        => $this->request->getPost('about'),
            'aboutimage' => $imageName,
            'mission'       => $this->request->getPost('mission'),
            'vision'       => $this->request->getPost('vision'),
            'objective'       => $this->request->getPost('objective'),
            'message'       => $this->request->getPost('message'),
            'image'       => $imageNamee,
            'mfrom'         => $this->request->getPost('mfrom'),
            'designation'   =>$this->request->getPost('designation')
        ]);

        return redirect()->to(base_url('admin/about'))->with('success', 'About updated successfully!');
    }

    public function delete($id)
    {
        $model = new AboutModel();
        $product = $model->find($id);

        // Delete single thumbnail
        if ($product && $product['aboutimage'] && file_exists('uploads/about/' . $product['aboutimage'])) {
            unlink('uploads/about/' . $product['aboutimage']);
        }

        if ($product && $product['image'] && file_exists('uploads/about/' . $product['image'])) {
            unlink('uploads/about/' . $product['image']);
        }

        $model->delete($id);
        return redirect()->to(base_url('admin/about'))->with('success', 'About deleted successfully!');
    }
}
