<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\MediaModel;

class Media extends BaseController
{
    public function index()
    {
        $model = new MediaModel();
        $data['media'] = $model->findAll();
        return view('admin/media/index', $data);
    }

    public function create()
    {
        return view('admin/media/create');
    }

    public function store()
{
    $model = new MediaModel();

    $images = $this->request->getFileMultiple('images');
    $inserted = false;

    if ($images) {
        foreach ($images as $img) {
            if ($img->isValid() && !$img->hasMoved()) {

                $imageName = $img->getRandomName();
                $img->move('uploads/media', $imageName);

                // Insert one image per row
                $model->insert([
                    'images' => $imageName
                ]);

                $inserted = true;
            }
        }
    }

    if ($inserted) {
        return redirect()->to(base_url('admin/media'))
            ->with('success', 'Images uploaded successfully!');
    }

    return redirect()->back()->with('error', 'No valid image selected!');
}



    public function delete($id)
    {
        $model = new MediaModel();
        $product = $model->find($id);

        // Delete multiple images
        if (!empty($product['images'])) {
            $multiImages = explode(',', $product['images']);
            foreach ($multiImages as $img) {
                if (file_exists('uploads/media/' . $img)) {
                    unlink('uploads/media/' . $img);
                }
            }
        }

        $model->delete($id);
        return redirect()->to(base_url('admin/media'))->with('success', 'Image deleted!');
    }
}
