<?php

namespace App\Controllers;
use App\Models\BlogModel;
use App\Controllers\BaseController;

class Blog extends BaseController
{

    public function index()
    {
        helper('text');

        
        $model = new BlogModel();
        $data['blogs'] = $model->orderBy('id', 'DESC')->findAll(3);

        return view('frontend/blog', $data);
    }

    public function detail($slug)
{
    $model = new \App\Models\BlogModel();
    
    // Fetch current blog
    $blog = $model->where('slug', $slug)->first();

    if (!$blog) {
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Blog not found");
    }

    // Fetch latest blogs except current one
    $latestBlogs = $model->where('id !=', $blog['id'])
                        ->orderBy('id', 'DESC')
                        ->limit(3)
                        ->find();

    return view('frontend/blog_detail', [
        'blog' => $blog,
        'latestBlogs' => $latestBlogs
    ]);
}


}
