<?php

namespace App\Controllers;

class Contact extends BaseController
{
    public function index(): string
    {
        return view('frontend/contact');
    }
    
    public function send()
    {
        $validation = \Config\Services::validation();

        $rules = [
            'name'    => 'required',
            'email'   => 'required|valid_email',
            'message' => 'required'
        ];

        if (!$this->validate($rules)) {
            return redirect()->back()->with('error', 'Please fill the required fields!')->withInput();
        }

        $name    = $this->request->getPost('name');
        $email   = $this->request->getPost('email');
        $phone   = $this->request->getPost('phone');
        $subject = $this->request->getPost('subject') ?: "New Website Enquiry";
        $message = $this->request->getPost('message');

        $adminEmail = "web@kreatz.com";  // Replace with your email

        $emailService = \Config\Services::email();

        $emailService->setTo($adminEmail);
        $emailService->setFrom($email, $name);
        $emailService->setSubject($subject);
        $emailService->setMessage("
            <strong>Name:</strong> $name <br>
            <strong>Email:</strong> $email <br>
            <strong>Phone:</strong> $phone <br><br>
            <strong>Message:</strong><br>$message
        ");

        if ($emailService->send()) {
            return redirect()->to(base_url('contact-us'))->with('success', 'Message sent successfully!');

        } else {
            return redirect()->to(base_url('contact-us'))->with('error', 'Please fill the required fields!')->withInput();
        }
    }
}
