<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Frontend Routes
$routes->get('/', 'Products::index');           // Homepage → products
$routes->get('products', 'Products::index');
$routes->get('about', 'About::index');    
$routes->get('product/(:num)', 'Products::details/$1'); // Product details

// Admin Routes
$routes->group('admin', ['filter' => 'auth'], function($routes) {
    // Protected routes
    $routes->get('dashboard', 'Admin\Dashboard::index');
    $routes->get('product', 'Admin\Product::index');
    $routes->get('product/create', 'Admin\Product::create');
    $routes->post('product/store', 'Admin\Product::store');
    $routes->get('product/edit/(:num)', 'Admin\Product::edit/$1');
    $routes->post('product/update/(:num)', 'Admin\Product::update/$1');
    $routes->get('product/delete/(:num)', 'Admin\Product::delete/$1');

    // Change password page
    $routes->get('change-password', 'Admin\Login::changePassword', ['filter' => 'auth']);
    $routes->post('change-password/update', 'Admin\Login::updatePassword', ['filter' => 'auth']);

});

// Exclude login routes from filter
$routes->get('admin', 'Admin\Login::index');
$routes->get('admin/login', 'Admin\Login::index');
$routes->post('admin/login/auth', 'Admin\Login::auth');

$routes->get('admin/logout', 'Admin\Login::logout');


