<!DOCTYPE html>
<html lang="en">
<head>
  <title>Aura - eCommerce Beauty Store HTML Website Template</title>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="format-detection" content="telephone=no">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="author" content="templatesjungle">
  <meta name="keywords" content="eCommerce, Beauty Store, HTML, Website Template">
  <meta name="description" content="Aura is an eCommerce Beauty Store HTML Website Template">
</head>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/icomoon/icomoon.css">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet"
  integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/vendor.css">
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/style.css">

<link rel="preconnect" href="https://fonts.googleapis.com/">
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
<link
  href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&amp;family=Lustria&amp;display=swap"
  rel="stylesheet">
</head>

<body>

  <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
    <defs>
      <symbol xmlns="http://www.w3.org/2000/svg" id="link" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M12 19a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm5 0a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm0-4a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm-5 0a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm7-12h-1V2a1 1 0 0 0-2 0v1H8V2a1 1 0 0 0-2 0v1H5a3 3 0 0 0-3 3v14a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3Zm1 17a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-9h16Zm0-11H4V6a1 1 0 0 1 1-1h1v1a1 1 0 0 0 2 0V5h8v1a1 1 0 0 0 2 0V5h1a1 1 0 0 1 1 1ZM7 15a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm0 4a1 1 0 1 0-1-1a1 1 0 0 0 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="arrow-right" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M17.92 11.62a1 1 0 0 0-.21-.33l-5-5a1 1 0 0 0-1.42 1.42l3.3 3.29H7a1 1 0 0 0 0 2h7.59l-3.3 3.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l5-5a1 1 0 0 0 .21-.33a1 1 0 0 0 0-.76Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="category" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M19 5.5h-6.28l-.32-1a3 3 0 0 0-2.84-2H5a3 3 0 0 0-3 3v13a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3v-10a3 3 0 0 0-3-3Zm1 13a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-13a1 1 0 0 1 1-1h4.56a1 1 0 0 1 .95.68l.54 1.64a1 1 0 0 0 .95.68h7a1 1 0 0 1 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="calendar" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M19 4h-2V3a1 1 0 0 0-2 0v1H9V3a1 1 0 0 0-2 0v1H5a3 3 0 0 0-3 3v12a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3V7a3 3 0 0 0-3-3Zm1 15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-7h16Zm0-9H4V7a1 1 0 0 1 1-1h2v1a1 1 0 0 0 2 0V6h6v1a1 1 0 0 0 2 0V6h2a1 1 0 0 1 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="heart" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M20.16 4.61A6.27 6.27 0 0 0 12 4a6.27 6.27 0 0 0-8.16 9.48l7.45 7.45a1 1 0 0 0 1.42 0l7.45-7.45a6.27 6.27 0 0 0 0-8.87Zm-1.41 7.46L12 18.81l-6.75-6.74a4.28 4.28 0 0 1 3-7.3a4.25 4.25 0 0 1 3 1.25a1 1 0 0 0 1.42 0a4.27 4.27 0 0 1 6 6.05Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="plus" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M19 11h-6V5a1 1 0 0 0-2 0v6H5a1 1 0 0 0 0 2h6v6a1 1 0 0 0 2 0v-6h6a1 1 0 0 0 0-2Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="minus" viewBox="0 0 24 24">
        <path fill="currentColor" d="M19 11H5a1 1 0 0 0 0 2h14a1 1 0 0 0 0-2Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="cart" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M8.5 19a1.5 1.5 0 1 0 1.5 1.5A1.5 1.5 0 0 0 8.5 19ZM19 16H7a1 1 0 0 1 0-2h8.491a3.013 3.013 0 0 0 2.885-2.176l1.585-5.55A1 1 0 0 0 19 5H6.74a3.007 3.007 0 0 0-2.82-2H3a1 1 0 0 0 0 2h.921a1.005 1.005 0 0 1 .962.725l.155.545v.005l1.641 5.742A3 3 0 0 0 7 18h12a1 1 0 0 0 0-2Zm-1.326-9l-1.22 4.274a1.005 1.005 0 0 1-.963.726H8.754l-.255-.892L7.326 7ZM16.5 19a1.5 1.5 0 1 0 1.5 1.5a1.5 1.5 0 0 0-1.5-1.5Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="check" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M18.71 7.21a1 1 0 0 0-1.42 0l-7.45 7.46l-3.13-3.14A1 1 0 1 0 5.29 13l3.84 3.84a1 1 0 0 0 1.42 0l8.16-8.16a1 1 0 0 0 0-1.47Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="trash" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M10 18a1 1 0 0 0 1-1v-6a1 1 0 0 0-2 0v6a1 1 0 0 0 1 1ZM20 6h-4V5a3 3 0 0 0-3-3h-2a3 3 0 0 0-3 3v1H4a1 1 0 0 0 0 2h1v11a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V8h1a1 1 0 0 0 0-2ZM10 5a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v1h-4Zm7 14a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1V8h10Zm-3-1a1 1 0 0 0 1-1v-6a1 1 0 0 0-2 0v6a1 1 0 0 0 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="star-outline" viewBox="0 0 15 15">
        <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
          d="M7.5 9.804L5.337 11l.413-2.533L4 6.674l2.418-.37L7.5 4l1.082 2.304l2.418.37l-1.75 1.793L9.663 11L7.5 9.804Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="star-solid" viewBox="0 0 15 15">
        <path fill="currentColor"
          d="M7.953 3.788a.5.5 0 0 0-.906 0L6.08 5.85l-2.154.33a.5.5 0 0 0-.283.843l1.574 1.613l-.373 2.284a.5.5 0 0 0 .736.518l1.92-1.063l1.921 1.063a.5.5 0 0 0 .736-.519l-.373-2.283l1.574-1.613a.5.5 0 0 0-.283-.844L8.921 5.85l-.968-2.062Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="search" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M21.71 20.29L18 16.61A9 9 0 1 0 16.61 18l3.68 3.68a1 1 0 0 0 1.42 0a1 1 0 0 0 0-1.39ZM11 18a7 7 0 1 1 7-7a7 7 0 0 1-7 7Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="user" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M15.71 12.71a6 6 0 1 0-7.42 0a10 10 0 0 0-6.22 8.18a1 1 0 0 0 2 .22a8 8 0 0 1 15.9 0a1 1 0 0 0 1 .89h.11a1 1 0 0 0 .88-1.1a10 10 0 0 0-6.25-8.19ZM12 12a4 4 0 1 1 4-4a4 4 0 0 1-4 4Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="close" viewBox="0 0 15 15">
        <path fill="currentColor"
          d="M7.953 3.788a.5.5 0 0 0-.906 0L6.08 5.85l-2.154.33a.5.5 0 0 0-.283.843l1.574 1.613l-.373 2.284a.5.5 0 0 0 .736.518l1.92-1.063l1.921 1.063a.5.5 0 0 0 .736-.519l-.373-2.283l1.574-1.613a.5.5 0 0 0-.283-.844L8.921 5.85l-.968-2.062Z" />
      </symbol>

    </defs>
  </svg>

  <!-- <div class="preloader-wrapper">
    <div class="preloader">
    </div>
  </div> -->

  <div class="offcanvas offcanvas-end" data-bs-scroll="true" tabindex="-1" id="offcanvasCart" aria-labelledby="My Cart">
    <div class="offcanvas-header justify-content-center">
      <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
      <div class="order-md-last">
        <h4 class="d-flex justify-content-between align-items-center mb-4">
          <span class="text-primary">Your cart</span>
          <span class="badge bg-primary rounded-circle pt-2">3</span>
        </h4>

        <ul class="list-group mb-4">
          <li class="list-group-item d-flex justify-content-between lh-sm">
            <div>
              <h6 class="my-0">Red Sunglasses</h6>
              <small class="text-body-secondary">Brief description</small>
            </div>
            <span class="text-body-secondary">$120</span>
          </li>
          <li class="list-group-item d-flex justify-content-between lh-sm">
            <div>
              <h6 class="my-0">Reading Glasses</h6>
              <small class="text-body-secondary">Brief description</small>
            </div>
            <span class="text-body-secondary">$80</span>
          </li>
          <li class="list-group-item d-flex justify-content-between lh-sm">
            <div>
              <h6 class="my-0">Fashion Glasses</h6>
              <small class="text-body-secondary">Brief description</small>
            </div>
            <span class="text-body-secondary">$50</span>
          </li>
          <li class="list-group-item d-flex justify-content-between">
            <span class="fw-bold">Total (USD)</span>
            <strong>$250</strong>
          </li>
        </ul>

        <button class="w-100 btn btn-dark" type="submit">Continue to checkout</button>
      </div>
    </div>
  </div>

  <div class="offcanvas offcanvas-end" data-bs-scroll="true" tabindex="-1" id="offcanvasSearch"
    aria-labelledby="Search">
    <div class="offcanvas-header justify-content-center">
      <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">

      <div class="order-md-last">
        <h4 class="text-primary text-uppercase mb-3">
          Search
        </h4>
        <div class="search-bar border rounded-2 border-dark-subtle">
          <form id="search-form" class="text-center d-flex align-items-center" action="#" method="">
            <input type="text" class="form-control border-0 bg-transparent" placeholder="Search Here" />
            <iconify-icon icon="tabler:search" class="fs-4 me-3"></iconify-icon>
          </form>
        </div>
      </div>
    </div>
  </div>

  <?php include("header.php"); ?>

  <section id="hero">
    <div class="swiper slideshow">
      <div class="swiper-wrapper">
        <div class="swiper-slide" style="background-image:url(images/banner2.jpg);">
          <div class="container padding-large">
            <div class="row justify-content-end">
              <div class="col-lg-6" data-aos="fade-up">
                <h2 class="display-1 text-uppercase text-white mt-3">Reveal Your Beauty</h2>
                <p class="text-capitalize text-white fs-5 mb-4">Discover Your Perfect Look With Premium Cosmetics</p>
                <a href="#" class="btn btn-light">
                  Shop Collection
                </a>
              </div>
            </div>
          </div>
        </div>
        <div class="swiper-slide" style="background-image:url(images/banner1.jpg);">
          <div class="container padding-large">
            <div class="row justify-content-end">
              <div class="col-lg-6" data-aos="fade-up">
                <h2 class="display-1 text-uppercase text-white mt-3">Enhance Your Glow</h2>
                <p class="text-capitalize text-white fs-5 mb-4">Illuminate Your Beauty With Premium Skincare</p>
                <a href="#" class="btn btn-light">
                  Shop Now
                </a>
              </div>
            </div>
          </div>
        </div>
        <div class="swiper-slide" style="background-image:url(images/banner3.jpg);">
          <div class="container padding-large">
            <div class="row justify-content-end">
              <div class="col-lg-6" data-aos="fade-up">
                <h2 class="display-1 text-uppercase text-white mt-3">Define Your Beauty</h2>
                <p class="text-capitalize text-white fs-5 mb-4">Transform Your Look With Luxury Cosmetics</p>
                <a href="#" class="btn btn-light">
                  Explore Products
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="swiper-pagination swiper-pagination-slideshow"></div>
    </div>
  </section>

  <section class="logo-bar">
    <div class="container padding-medium" data-aos="fade-up">
      <div class="row ">
        <div class="logo-content d-flex flex-wrap justify-content-between">
          <a href="#"> <img src="images/logo1.png" alt="logo" class="logo-image img-fluid my-3"> </a>
          <a href="#"> <img src="images/logo2.png" alt="logo" class="logo-image img-fluid my-3"> </a>
          <a href="#"> <img src="images/logo3.png" alt="logo" class="logo-image img-fluid my-3"> </a>
          <a href="#"> <img src="images/logo4.png" alt="logo" class="logo-image img-fluid my-3"> </a>
          <a href="#"> <img src="images/logo5.png" alt="logo" class="logo-image img-fluid my-3"> </a>
        </div>
      </div>
    </div>
  </section>

  <section id="category">
    <div class="container-fluid px-3 px-md-5">
      <div class="row">
        <div class="col-md-4 position-relative" data-aos="fade-up" data-aos-delay="300">
          <div class="z-1 position-absolute bottom-0 start-0 m-3 m-lg-5 ps-4 text-white">
            <h3 class="text-light text-uppercase">Skincare Essentials</h3>
          </div>
          <div class="image-holder zoom-effect">
            <a href="single-post.html">
              <img src="images/category1.jpg" alt="Luxury skincare products" class="post-image img-fluid">
            </a>
          </div>
        </div>
        <div class="col-md-4 position-relative" data-aos="fade-up" data-aos-delay="600">
          <div class="z-1 position-absolute bottom-0 start-0 m-3 m-lg-5 ps-4 text-white">
            <h3 class="text-light text-uppercase">Makeup Collection</h3>
          </div>
          <div class="image-holder zoom-effect">
            <a href="single-post.html">
              <img src="images/category3.jpg" alt="Premium makeup products" class="post-image img-fluid">
            </a>
          </div>
        </div>
        <div class="col-md-4 position-relative" data-aos="fade-up" data-aos-delay="900">
          <div class="z-1 position-absolute bottom-0 start-0 m-3 m-lg-5 ps-4 text-white">
            <h3 class="text-light text-uppercase">Fragrance & Scents</h3>
          </div>
          <div class="image-holder zoom-effect">
            <a href="single-post.html">
              <img src="images/category2.jpg" alt="Luxury perfume bottles" class="post-image img-fluid">
            </a>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section id="new-arrival" class="product-store">
    <div class="container padding-medium" data-aos="fade-up">
      <h2 class="display-5 fw-light text-uppercase text-center">New Arrivals</h2>
      <p class="text-center mb-4">Browse our brand new collections</p>
      <div class="row">
      	<?php if(!empty($products)): ?>
        <?php foreach($products as $p): ?>
        <div class="col-md-6 col-lg-3 my-4">
          <div class="product-item position-relative">
            <div class="z-1 position-absolute top-0 start-0 rounded-3 m-3 px-3 py-0 fs-6 bg-primary text-white">
              New
            </div>
            <div class="image-holder">
            	<?php if($p['image']): ?>
                <img src="<?= base_url('uploads/products/'.$p['image']) ?>" class="card-img-top" alt="<?= esc($p['name']) ?>" alt="Books" class="product-image img-fluid">
              <?php else: ?>
                <img src="<?= base_url('uploads/no-image.png') ?>" class="card-img-top" alt="No image">
              <?php endif; ?>
             
            </div>
            <div class="cart-concern">
              <div class="cart-button d-flex justify-content-between align-items-center">
                <a href="<?= base_url('product/'.$p['id']) ?>" class="btn-wrap cart-link d-flex align-items-center text-capitalize fs-6 ">Explore More <i
                    class="icon icon-arrow-io pe-1"></i>
                </a>
                <a href="single-product.html" class="view-btn mt-1">
                  <i class="icon icon-screen-full"></i>
                </a>
                <a href="#" class="wishlist-btn mt-1">
                  <i class="icon icon-heart"></i>
                </a>
              </div>
            </div>
            <div class="product-detail d-flex justify-content-between align-items-center mt-2">
              <a href="single-product.html">
                <h5 class="product-title mb-0"> <?= esc($p['name']) ?> </h5>
              </a>
              <p class="m-0 fs-5 fw-normal">₹<?= esc($p['price']) ?></p>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      <?php else: ?>
        <p class="text-center">No products available.</p>
      <?php endif; ?>
      </div>
      <div class="text-center mt-5 pt-4">
        <button type="submit" class="btn btn-primary">View All Products</button>
      </div>
    </div>
  </section>

  <section id="register"
    style="background-image:url(images/background-img.jpg); background-repeat: no-repeat; background-position: center;">
    <div class="container padding-medium" data-aos="fade-up">
      <div class="row banner-content justify-content-center align-items-center">
        <div class="col-md-6">
          <h2 class="display-2">Get <span> <em>20% OFF</em> </span> on your first purchase</h2>
          <p class="m-0">Sign Up for our newsletter and never miss any offers</p>
        </div>
        <div class="col-md-4">
          <form>
            <div class="mb-3">
              <input type="email" class="form-control form-control-lg rounded-3 text-center bg-light" name="email"
                id="email" placeholder="Enter Your Email Address">
            </div>
            <div class="d-grid gap-2">
              <button type="submit" class="btn btn-primary btn-lg rounded-3">Register now</button>
            </div>
          </form>
        </div>

      </div>
    </div>
  </section>

  <section id="best-seller" class="product-store">
    <div class="container padding-medium" data-aos="fade-up">
      <h2 class="display-5 fw-light text-uppercase text-center">Best Sellers</h2>
      <p class="text-center mb-4">Elevate your daily looks with our best sellers</p>
      <div class="row">
        <div class="col-md-6 col-lg-3 my-4">
          <div class="product-item">
            <div class="image-holder" style="width: 100%; height: 100%;">
              <img src="images/product-item2.jpg" alt="Books" class="product-image img-fluid">
            </div>
            <div class="cart-concern">
              <div class="cart-button d-flex justify-content-between align-items-center">
                <a href="single-product.html" class="btn-wrap cart-link d-flex align-items-center text-capitalize fs-6 ">Explore More <i
                    class="icon icon-arrow-io pe-1"></i>
                </a>
                <a href="single-product.html" class="view-btn mt-1">
                  <i class="icon icon-screen-full"></i>
                </a>
                <a href="#" class="wishlist-btn mt-1">
                  <i class="icon icon-heart"></i>
                </a>
              </div>
            </div>
            <div class="product-detail d-flex justify-content-between align-items-center mt-2">
              <a href="single-product.html">
                <h5 class="product-title mb-0"> Product Sample </h5>
              </a>
              <p class="m-0 fs-5 fw-normal">$40.00</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-3 my-4">

          <div class="product-item position-relative">
            <div class="z-1 position-absolute rounded-3 m-3 px-3 py-0 fs-6 bg-primary text-white">
              New
            </div>
            <div class="image-holder">
              <img src="images/product-item9.jpg" alt="Books" class="product-image img-fluid">
            </div>
            <div class="cart-concern">
              <div class="cart-button d-flex justify-content-between align-items-center">
                <a href="single-product.html" class="btn-wrap cart-link d-flex align-items-center text-capitalize fs-6 ">Explore More <i
                    class="icon icon-arrow-io pe-1"></i>
                </a>
                <a href="single-product.html" class="view-btn mt-1">
                  <i class="icon icon-screen-full"></i>
                </a>
                <a href="#" class="wishlist-btn mt-1">
                  <i class="icon icon-heart"></i>
                </a>
              </div>
            </div>
            <div class="product-detail d-flex justify-content-between align-items-center mt-2">
              <a href="single-product.html">
                <h5 class="product-title mb-0"> Product Sample </h5>
              </a>
              <p class="m-0 fs-5 fw-normal">$40.00</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-3 my-4">
          <div class="product-item">
            <div class="image-holder">
              <img src="images/product-item10.jpg" alt="Books" class="product-image img-fluid">
            </div>
            <div class="cart-concern">
              <div class="cart-button d-flex justify-content-between align-items-center">
                <a href="single-product.html" class="btn-wrap cart-link d-flex align-items-center text-capitalize fs-6 ">Explore More <i
                    class="icon icon-arrow-io pe-1"></i>
                </a>
                <a href="single-product.html" class="view-btn mt-1">
                  <i class="icon icon-screen-full"></i>
                </a>
                <a href="#" class="wishlist-btn mt-1">
                  <i class="icon icon-heart"></i>
                </a>
              </div>
            </div>
            <div class="product-detail d-flex justify-content-between align-items-center mt-2">
              <a href="single-product.html">
                <h5 class="product-title mb-0"> Product Sample </h5>
              </a>
              <p class="m-0 fs-5 fw-normal">$40.00</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-3 my-4">

          <div class="product-item position-relative">
            <div class="z-1 position-absolute rounded-3 m-3 px-3 bg-primary text-white">
              Sale
            </div>
            <div class="image-holder">
              <img src="images/product-item8.jpg" alt="Books" class="product-image img-fluid">
            </div>
            <div class="cart-concern">
              <div class="cart-button d-flex justify-content-between align-items-center">
                <a href="single-product.html" class="btn-wrap cart-link d-flex align-items-center text-capitalize fs-6 ">Explore More <i
                    class="icon icon-arrow-io pe-1"></i>
                </a>
                <a href="single-product.html" class="view-btn mt-1">
                  <i class="icon icon-screen-full"></i>
                </a>
                <a href="#" class="wishlist-btn mt-1">
                  <i class="icon icon-heart"></i>
                </a>
              </div>
            </div>
            <div class="product-detail d-flex justify-content-between align-items-center mt-2">
              <a href="single-product.html">
                <h5 class="product-title mb-0"> Product Sample </h5>
              </a>
              <p class="m-0 fs-5 fw-normal">$40.00</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-3 my-4">
          <div class="product-item">
            <div class="image-holder">
              <img src="images/product-item7.jpg" alt="Books" class="product-image img-fluid">
            </div>
            <div class="cart-concern">
              <div class="cart-button d-flex justify-content-between align-items-center">
                <a href="single-product.html" class="btn-wrap cart-link d-flex align-items-center text-capitalize fs-6 ">Explore More <i
                    class="icon icon-arrow-io pe-1"></i>
                </a>
                <a href="single-product.html" class="view-btn mt-1">
                  <i class="icon icon-screen-full"></i>
                </a>
                <a href="#" class="wishlist-btn mt-1">
                  <i class="icon icon-heart"></i>
                </a>
              </div>
            </div>
            <div class="product-detail d-flex justify-content-between align-items-center mt-2">
              <a href="single-product.html">
                <h5 class="product-title mb-0"> Product Sample </h5>
              </a>
              <p class="m-0 fs-5 fw-normal">$40.00</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-3 my-4">
          <div class="product-item">
            <div class="image-holder">
              <img src="images/product-item4.jpg" alt="Books" class="product-image img-fluid">
            </div>
            <div class="cart-concern">
              <div class="cart-button d-flex justify-content-between align-items-center">
                <a href="single-product.html" class="btn-wrap cart-link d-flex align-items-center text-capitalize fs-6 ">Explore More <i
                    class="icon icon-arrow-io pe-1"></i>
                </a>
                <a href="single-product.html" class="view-btn mt-1">
                  <i class="icon icon-screen-full"></i>
                </a>
                <a href="#" class="wishlist-btn mt-1">
                  <i class="icon icon-heart"></i>
                </a>
              </div>
            </div>
            <div class="product-detail d-flex justify-content-between align-items-center mt-2">
              <a href="single-product.html">
                <h5 class="product-title mb-0"> Product Sample </h5>
              </a>
              <p class="m-0 fs-5 fw-normal">$40.00</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-3 my-4">
          <div class="product-item position-relative">
            <div class="z-1 position-absolute rounded-3 m-3 px-3 bg-primary text-white">
              Sold
            </div>
            <div class="image-holder">
              <img src="images/product-item11.jpg" alt="Books" class="product-image img-fluid">
            </div>
            <div class="cart-concern">
              <div class="cart-button d-flex justify-content-between align-items-center">
                <a href="single-product.html" class="btn-wrap cart-link d-flex align-items-center text-capitalize fs-6 ">Explore More <i
                    class="icon icon-arrow-io pe-1"></i>
                </a>
                <a href="single-product.html" class="view-btn mt-1">
                  <i class="icon icon-screen-full"></i>
                </a>
                <a href="#" class="wishlist-btn mt-1">
                  <i class="icon icon-heart"></i>
                </a>
              </div>
            </div>
            <div class="product-detail d-flex justify-content-between align-items-center mt-2">
              <a href="single-product.html">
                <h5 class="product-title mb-0"> Product Sample </h5>
              </a>
              <p class="m-0 fs-5 fw-normal">$40.00</p>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-3 my-4">
          <div class="product-item">
            <div class="image-holder">
              <img src="images/product-item3.jpg" alt="Books" class="product-image img-fluid">
            </div>
            <div class="cart-concern">
              <div class="cart-button d-flex justify-content-between align-items-center">
                <a href="single-product.html" class="btn-wrap cart-link d-flex align-items-center text-capitalize fs-6 ">Explore More <i
                    class="icon icon-arrow-io pe-1"></i>
                </a>
                <a href="single-product.html" class="view-btn mt-1">
                  <i class="icon icon-screen-full"></i>
                </a>
                <a href="#" class="wishlist-btn mt-1">
                  <i class="icon icon-heart"></i>
                </a>
              </div>
            </div>
            <div class="product-detail d-flex justify-content-between align-items-center mt-2">
              <a href="single-product.html">
                <h5 class="product-title mb-0"> Product Sample </h5>
              </a>
              <p class="m-0 fs-5 fw-normal">$40.00</p>
            </div>
          </div>
        </div>

      </div>
      <div class="text-center mt-5 pt-4">
        <button type="submit" class="btn btn-primary">View All Products</button>
      </div>
    </div>
  </section>

  <section class="testimonials bg-primary padding-medium"
    style="background-image:url(images/background-img1.jpg); background-repeat: no-repeat; background-position: center;">
    <div class="swiper testimonial-swiper overflow-hidden" data-aos="fade-up">
      <div class="swiper-wrapper d-flex">
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <blockquote>
              <p>“This skincare serum completely transformed my complexion. My skin has never felt more hydrated and
                radiant!”</p>
              <div class="review-title mt-3 text-uppercase text-center">- Glowing Results</div>
            </blockquote>
          </div>
        </div>
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <blockquote>
              <p>“The foundation provides perfect coverage while feeling lightweight. It's become my daily essential.”
              </p>
              <div class="review-title mt-3 text-uppercase text-center">- Sophia</div>
            </blockquote>
          </div>
        </div>
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <blockquote>
              <p>“The fragrance lasts all day and I constantly receive compliments. Absolutely worth every penny!”</p>
              <div class="review-title mt-3 text-uppercase text-center">- Signature Scent</div>
            </blockquote>
          </div>
        </div>
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <blockquote>
              <p>“These products are cruelty-free and actually deliver visible results. My new beauty ritual!”</p>
              <div class="review-title mt-3 text-uppercase text-center">- Emma</div>
            </blockquote>
          </div>
        </div>
      </div>
    </div>
  </section>

  <section id="service" class="padding-medium">
    <div class="container" data-aos="fade-up">
      <div class="row">
        <div class="col-md-3 my-3">
          <div class="card">
            <div>
              <iconify-icon class="service-icon text-primary display-4" icon="ci:shopping-cart-02"></iconify-icon>
            </div>
            <h4 class=" text-uppercase py-3 m-0">Free Delivery</h3>
              <div class="card-text">
                <p>Lorem ipsum dolor sit amet, consectetur adipi elit.</p>
              </div>
          </div>
        </div>
        <div class="col-md-3 my-3">
          <div class="card">
            <div>
              <iconify-icon class="service-icon text-primary display-4" icon="tdesign:secured"></iconify-icon>
            </div>
            <h4 class=" text-uppercase py-3 m-0">100% secure payment</h3>
              <div class="card-text">
                <p>Lorem ipsum dolor sit amet, consectetur adipi elit.</p>
              </div>
          </div>
        </div>
        <div class="col-md-3 my-3">
          <div class="card">
            <div>
              <iconify-icon class="service-icon text-primary display-4" icon="la:award"></iconify-icon>
            </div>
            <h4 class=" text-uppercase py-3 m-0">Quality guarantee</h3>
              <div class="card-text">
                <p>Lorem ipsum dolor sit amet, consectetur adipi elit.</p>
              </div>
          </div>
        </div>
        <div class="col-md-3 my-3">
          <div class="card">
            <div>
              <iconify-icon class="service-icon text-primary display-4" icon="solar:dollar-outline"></iconify-icon>
            </div>
            <h4 class=" text-uppercase py-3 m-0">Daily Offer</h3>
              <div class="card-text">
                <p>Lorem ipsum dolor sit amet, consectetur adipi elit.</p>
              </div>
          </div>
        </div>

      </div>
    </div>
  </section>

  <div id="blog" class="padding-medium pt-0">
    <div class="container" data-aos="fade-up">
      <div class="section-header d-md-flex justify-content-between align-items-center mb-3">
        <h2 class="display-5 fw-light text-uppercase">Recent Blog Post</h2>
        <div>
          <a href="blog.html" class="btn btn-primary">
            Read Blog</a>
        </div>
      </div>
      <div class="row">
        <div class="col-md-4 my-4" data-aos="fade-up" data-aos-delay="300">
          <div class="card position-relative">
            <div class="z-1 position-absolute m-2 px-3 pt-1">
              <h2 class="text-light display-4 m-0">20<span class="fs-4">MAR</span> </h2>
            </div>
            <a href="single-post.html"><img src="images/blog5.jpg" class="img-fluid" alt="Summer skincare routine"></a>
            <div class="card-body p-0">
              <a href="single-post.html">
                <h3 class="pt-4 pb-3 m-0">10 Essential Summer Skincare Tips</h3>
              </a>
              <div class="card-text">
                <p>Protect your skin from sun damage while maintaining that healthy glow. Discover our
                  expert-recommended summer skincare routine that will keep your complexion radiant all season long.</p>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-4 my-4" data-aos="fade-up" data-aos-delay="600">
          <div class="card position-relative">
            <div class="z-1 position-absolute m-2 px-3 pt-1">
              <h2 class="text-light display-4 m-0">21<span class="fs-4">MAR</span> </h2>
            </div>
            <a href="single-post.html"><img src="images/blog2.jpg" class="img-fluid"
                alt="Affordable beauty products"></a>
            <div class="card-body p-0">
              <a href="single-post.html">
                <h3 class="pt-4 pb-3 m-0">Luxury Beauty Brands on a Budget</h3>
              </a>
              <div class="card-text">
                <p>You don't need to break the bank for premium beauty results. We've curated the best affordable
                  alternatives to high-end products that deliver exceptional quality without the luxury price tag.</p>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-4 my-4" data-aos="fade-up" data-aos-delay="900">
          <div class="card position-relative">
            <div class="z-1 position-absolute m-2 px-3 pt-1">
              <h2 class="text-light display-4 m-0">22<span class="fs-4">MAR</span> </h2>
            </div>
            <a href="single-post.html"><img src="images/blog1.jpg" class="img-fluid" alt="Professional makeup tips"></a>
            <div class="card-body p-0">
              <a href="single-post.html">
                <h3 class="pt-4 pb-3 m-0">Pro Makeup Artist Secrets Revealed</h3>
              </a>
              <div class="card-text">
                <p>Learn the techniques that professional makeup artists use to create flawless looks. From foundation
                  application to perfect winged eyeliner, master these skills for everyday glamour.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <?php include("footer.php"); ?>

  <div id="footer-bottom" class="bg-primary">
    <hr class="text-light m-0">
    <div class="container text-light pt-3">
      <div class="row">
        <div class="col-md-6 copyright">
          <p>© 2025 AURA. All rights reserved.</p>
        </div>
        <div class="col-md-6 text-md-end">
          <p>HTML Template by: <a href="https://templatesjungle.com/" target="_blank"
              class="text-light text-decoration-underline"> TemplatesJungle</a> </p>
        </div>
      </div>
    </div>
  </div>

  <script src="<?= base_url() ?>public/js/jquery-1.11.0.min.js"></script>
  <script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/swiper%409/swiper-bundle.min.js"></script>
  <script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/bootstrap%405.3.0-alpha3/dist/js/bootstrap.bundle.min.js"
    integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe"
    crossorigin="anonymous"></script>
  <script src="<?= base_url() ?>public/js/plugins.js"></script>
  <script src="<?= base_url() ?>public/js/script.js"></script>
  <script src="../../code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
</body>


<!-- Mirrored from demo.templatesjungle.com/aura/index.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 17 Oct 2025 04:04:13 GMT -->
</html>