<!DOCTYPE html>
<html lang="en">

<head>
 <title>Aura - eCommerce Beauty Store HTML Website Template</title>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="format-detection" content="telephone=no">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="author" content="templatesjungle">
  <meta name="keywords" content="eCommerce, Beauty Store, HTML, Website Template">
  <meta name="description" content="Aura is an eCommerce Beauty Store HTML Website Template">
</head>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/icomoon/icomoon.css">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet"
  integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/vendor.css">
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/style.css">

<link rel="preconnect" href="https://fonts.googleapis.com/">
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
<link
  href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&amp;family=Lustria&amp;display=swap"
  rel="stylesheet">
</head>

<body>

  <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
    <defs>
      <symbol xmlns="http://www.w3.org/2000/svg" id="link" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M12 19a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm5 0a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm0-4a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm-5 0a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm7-12h-1V2a1 1 0 0 0-2 0v1H8V2a1 1 0 0 0-2 0v1H5a3 3 0 0 0-3 3v14a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3Zm1 17a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-9h16Zm0-11H4V6a1 1 0 0 1 1-1h1v1a1 1 0 0 0 2 0V5h8v1a1 1 0 0 0 2 0V5h1a1 1 0 0 1 1 1ZM7 15a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm0 4a1 1 0 1 0-1-1a1 1 0 0 0 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="arrow-right" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M17.92 11.62a1 1 0 0 0-.21-.33l-5-5a1 1 0 0 0-1.42 1.42l3.3 3.29H7a1 1 0 0 0 0 2h7.59l-3.3 3.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l5-5a1 1 0 0 0 .21-.33a1 1 0 0 0 0-.76Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="category" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M19 5.5h-6.28l-.32-1a3 3 0 0 0-2.84-2H5a3 3 0 0 0-3 3v13a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3v-10a3 3 0 0 0-3-3Zm1 13a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-13a1 1 0 0 1 1-1h4.56a1 1 0 0 1 .95.68l.54 1.64a1 1 0 0 0 .95.68h7a1 1 0 0 1 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="calendar" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M19 4h-2V3a1 1 0 0 0-2 0v1H9V3a1 1 0 0 0-2 0v1H5a3 3 0 0 0-3 3v12a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3V7a3 3 0 0 0-3-3Zm1 15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-7h16Zm0-9H4V7a1 1 0 0 1 1-1h2v1a1 1 0 0 0 2 0V6h6v1a1 1 0 0 0 2 0V6h2a1 1 0 0 1 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="heart" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M20.16 4.61A6.27 6.27 0 0 0 12 4a6.27 6.27 0 0 0-8.16 9.48l7.45 7.45a1 1 0 0 0 1.42 0l7.45-7.45a6.27 6.27 0 0 0 0-8.87Zm-1.41 7.46L12 18.81l-6.75-6.74a4.28 4.28 0 0 1 3-7.3a4.25 4.25 0 0 1 3 1.25a1 1 0 0 0 1.42 0a4.27 4.27 0 0 1 6 6.05Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="plus" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M19 11h-6V5a1 1 0 0 0-2 0v6H5a1 1 0 0 0 0 2h6v6a1 1 0 0 0 2 0v-6h6a1 1 0 0 0 0-2Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="minus" viewBox="0 0 24 24">
        <path fill="currentColor" d="M19 11H5a1 1 0 0 0 0 2h14a1 1 0 0 0 0-2Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="cart" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M8.5 19a1.5 1.5 0 1 0 1.5 1.5A1.5 1.5 0 0 0 8.5 19ZM19 16H7a1 1 0 0 1 0-2h8.491a3.013 3.013 0 0 0 2.885-2.176l1.585-5.55A1 1 0 0 0 19 5H6.74a3.007 3.007 0 0 0-2.82-2H3a1 1 0 0 0 0 2h.921a1.005 1.005 0 0 1 .962.725l.155.545v.005l1.641 5.742A3 3 0 0 0 7 18h12a1 1 0 0 0 0-2Zm-1.326-9l-1.22 4.274a1.005 1.005 0 0 1-.963.726H8.754l-.255-.892L7.326 7ZM16.5 19a1.5 1.5 0 1 0 1.5 1.5a1.5 1.5 0 0 0-1.5-1.5Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="check" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M18.71 7.21a1 1 0 0 0-1.42 0l-7.45 7.46l-3.13-3.14A1 1 0 1 0 5.29 13l3.84 3.84a1 1 0 0 0 1.42 0l8.16-8.16a1 1 0 0 0 0-1.47Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="trash" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M10 18a1 1 0 0 0 1-1v-6a1 1 0 0 0-2 0v6a1 1 0 0 0 1 1ZM20 6h-4V5a3 3 0 0 0-3-3h-2a3 3 0 0 0-3 3v1H4a1 1 0 0 0 0 2h1v11a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V8h1a1 1 0 0 0 0-2ZM10 5a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v1h-4Zm7 14a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1V8h10Zm-3-1a1 1 0 0 0 1-1v-6a1 1 0 0 0-2 0v6a1 1 0 0 0 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="star-outline" viewBox="0 0 15 15">
        <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
          d="M7.5 9.804L5.337 11l.413-2.533L4 6.674l2.418-.37L7.5 4l1.082 2.304l2.418.37l-1.75 1.793L9.663 11L7.5 9.804Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="star-solid" viewBox="0 0 15 15">
        <path fill="currentColor"
          d="M7.953 3.788a.5.5 0 0 0-.906 0L6.08 5.85l-2.154.33a.5.5 0 0 0-.283.843l1.574 1.613l-.373 2.284a.5.5 0 0 0 .736.518l1.92-1.063l1.921 1.063a.5.5 0 0 0 .736-.519l-.373-2.283l1.574-1.613a.5.5 0 0 0-.283-.844L8.921 5.85l-.968-2.062Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="search" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M21.71 20.29L18 16.61A9 9 0 1 0 16.61 18l3.68 3.68a1 1 0 0 0 1.42 0a1 1 0 0 0 0-1.39ZM11 18a7 7 0 1 1 7-7a7 7 0 0 1-7 7Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="user" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M15.71 12.71a6 6 0 1 0-7.42 0a10 10 0 0 0-6.22 8.18a1 1 0 0 0 2 .22a8 8 0 0 1 15.9 0a1 1 0 0 0 1 .89h.11a1 1 0 0 0 .88-1.1a10 10 0 0 0-6.25-8.19ZM12 12a4 4 0 1 1 4-4a4 4 0 0 1-4 4Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="close" viewBox="0 0 15 15">
        <path fill="currentColor"
          d="M7.953 3.788a.5.5 0 0 0-.906 0L6.08 5.85l-2.154.33a.5.5 0 0 0-.283.843l1.574 1.613l-.373 2.284a.5.5 0 0 0 .736.518l1.92-1.063l1.921 1.063a.5.5 0 0 0 .736-.519l-.373-2.283l1.574-1.613a.5.5 0 0 0-.283-.844L8.921 5.85l-.968-2.062Z" />
      </symbol>

    </defs>
  </svg>

  <div class="preloader-wrapper">
    <div class="preloader">
    </div>
  </div>

  <div class="offcanvas offcanvas-end" data-bs-scroll="true" tabindex="-1" id="offcanvasCart" aria-labelledby="My Cart">
    <div class="offcanvas-header justify-content-center">
      <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
      <div class="order-md-last">
        <h4 class="d-flex justify-content-between align-items-center mb-4">
          <span class="text-primary">Your cart</span>
          <span class="badge bg-primary rounded-circle pt-2">3</span>
        </h4>

        <ul class="list-group mb-4">
          <li class="list-group-item d-flex justify-content-between lh-sm">
            <div>
              <h6 class="my-0">Red Sunglasses</h6>
              <small class="text-body-secondary">Brief description</small>
            </div>
            <span class="text-body-secondary">$120</span>
          </li>
          <li class="list-group-item d-flex justify-content-between lh-sm">
            <div>
              <h6 class="my-0">Reading Glasses</h6>
              <small class="text-body-secondary">Brief description</small>
            </div>
            <span class="text-body-secondary">$80</span>
          </li>
          <li class="list-group-item d-flex justify-content-between lh-sm">
            <div>
              <h6 class="my-0">Fashion Glasses</h6>
              <small class="text-body-secondary">Brief description</small>
            </div>
            <span class="text-body-secondary">$50</span>
          </li>
          <li class="list-group-item d-flex justify-content-between">
            <span class="fw-bold">Total (USD)</span>
            <strong>$250</strong>
          </li>
        </ul>

        <button class="w-100 btn btn-dark" type="submit">Continue to checkout</button>
      </div>
    </div>
  </div>

  <div class="offcanvas offcanvas-end" data-bs-scroll="true" tabindex="-1" id="offcanvasSearch"
    aria-labelledby="Search">
    <div class="offcanvas-header justify-content-center">
      <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">

      <div class="order-md-last">
        <h4 class="text-primary text-uppercase mb-3">
          Search
        </h4>
        <div class="search-bar border rounded-2 border-dark-subtle">
          <form id="search-form" class="text-center d-flex align-items-center" action="#" method="">
            <input type="text" class="form-control border-0 bg-transparent" placeholder="Search Here" />
            <iconify-icon icon="tabler:search" class="fs-4 me-3"></iconify-icon>
          </form>
        </div>
      </div>
    </div>
  </div>

  <nav class="main-menu d-flex navbar fixed-top navbar-expand-lg py-lg-4">
    <div class="container">
      <div class="main-logo d-lg-none">
        <a href="index.html">
          <img src="images/logo.png" alt="logo" class="img-fluid">
        </a>
      </div>

      <button class="navbar-toggler border-0 shadow-none " type="button" data-bs-toggle="offcanvas"
        data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="offcanvas offcanvas-end bg-black" tabindex="-1" id="offcanvasNavbar"
        aria-labelledby="offcanvasNavbarLabel">

        <div class="offcanvas-header justify-content-center">
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"
            aria-label="Close"></button>
        </div>

        <div class="offcanvas-body justify-content-between align-items-center">

          <div class="main-logo">
            <a href="index.html">
              <img src="images/logo.png" alt="logo" class="img-fluid">
            </a>
          </div>

          <ul class="navbar-nav menu-list list-unstyled d-flex gap-md-3 ps-lg-5 mb-0">
            <li class="nav-item">
              <a href="index.html" class="nav-link mx-2 active">Home</a>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link mx-2 dropdown-toggle" role="button" id="pages" data-bs-toggle="dropdown"
                aria-expanded="false">Pages</a>
              <ul class="dropdown-menu p-3 p-lg-0" aria-labelledby="pages">
                <li><a href="about.html" class="dropdown-item">About Us<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
                <li><a href="cart.html" class="dropdown-item">Cart<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
                <li><a href="wishlist.html" class="dropdown-item">Wishlist<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
                <li><a href="checkout.html" class="dropdown-item">Checkout<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
                <li><a href="contact.html" class="dropdown-item">Contact<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
                <li><a href="faqs.html" class="dropdown-item">FAQs<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
                <li><a href="account.html" class="dropdown-item">Account<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
                <li><a href="thank-you.html" class="dropdown-item">Thankyou<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
                <li><a href="error.html" class="dropdown-item">Error 404<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
                <li><a href="styles.html" class="dropdown-item">Styles<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
              </ul>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link mx-2 dropdown-toggle" role="button" id="pages" data-bs-toggle="dropdown"
                aria-expanded="false">Shop</a>
              <ul class="dropdown-menu p-3 p-lg-0" aria-labelledby="pages">
                <li><a href="shop.html" class="dropdown-item">Shop<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
                <li><a href="single-product.html" class="dropdown-item">Single Product<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
              </ul>
            </li>
            <li class="nav-item dropdown">
              <a class="nav-link mx-2 dropdown-toggle" role="button" id="pages" data-bs-toggle="dropdown"
                aria-expanded="false">Blog</a>
              <ul class="dropdown-menu p-3 p-lg-0" aria-labelledby="pages">
                <li><a href="blog.html" class="dropdown-item">Blog<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
                <li><a href="single-post.html" class="dropdown-item">Single Post<span
                      class="badge bg-primary text-light ms-2">PRO</span></a></li>
              </ul>
            </li>

            <li class="nav-item">
              <a href="contact.html" class="nav-link mx-2">Contact</a>
            </li>

            <li class="nav-item">
              <a href="https://templatesjungle.gumroad.com/l/aura"
                class="nav-link fw-bold text-decoration-underline mx-2" target="_blank">GET PRO</a>
            </li>
          </ul>

          <div class="d-none d-lg-flex justify-content-end">
            <ul class="d-flex justify-content-end list-unstyled m-0">
              <li class="lh-1">
                <a href="account.html" class="mx-3">
                  <iconify-icon icon="healthicons:person" class="fs-4 text-light"></iconify-icon>
                </a>
              </li>
              <li class="lh-1">
                <a href="wishlist.html" class="mx-3">
                  <iconify-icon icon="mdi:heart" class="fs-4 text-light"></iconify-icon>
                </a>
              </li>

              <li class="lh-1">
                <a href="#" class="mx-3" data-bs-toggle="offcanvas" data-bs-target="#offcanvasCart"
                  aria-controls="offcanvasCart">
                  <iconify-icon icon="mdi:cart" class="fs-4 text-light position-relative"></iconify-icon>
                  <span class="position-absolute translate-middle badge rounded-circle text-black bg-light p-1">
                    03
                  </span>
                </a>
              </li>

              <li class="lh-1">
                <a href="#" class="mx-3" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSearch"
                  aria-controls="offcanvasSearch">
                  <iconify-icon icon="tabler:search" class="fs-4 text-light"></iconify-icon>
                </a>
              </li>

            </ul>

          </div>

        </div>
      </div>
    </div>

    <div class="container-fluid px-md-5 d-lg-none">
      <ul class="d-flex justify-content-end list-unstyled m-0 mt-4">
        <li class="lh-1">
          <a href="account.html" class="me-4">
            <iconify-icon icon="healthicons:person" class="fs-4 text-light"></iconify-icon>
          </a>
        </li>
        <li class="lh-1">
          <a href="wishlist.html" class="me-4">
            <iconify-icon icon="mdi:heart" class="fs-4 text-light"></iconify-icon>
          </a>
        </li>

        <li class="lh-1">
          <a href="#" class="me-4" data-bs-toggle="offcanvas" data-bs-target="#offcanvasCart"
            aria-controls="offcanvasCart">
            <iconify-icon icon="mdi:cart" class="fs-4 text-light position-relative"></iconify-icon>
            <span class="position-absolute translate-middle badge rounded-circle text-black bg-light p-1">
              03
            </span>
          </a>
        </li>

        <li class="lh-1">
          <a href="#" class="me-4" data-bs-toggle="offcanvas" data-bs-target="#offcanvasSearch"
            aria-controls="offcanvasSearch">
            <iconify-icon icon="tabler:search" class="fs-4 text-light"></iconify-icon>
          </a>
        </li>
      </ul>
    </div>
  </nav>

  <section id="banner"
    style="background-image:url(images/banner-img2.jpg); background-repeat: no-repeat; background-position: center;">
    <div class="container padding-medium-2">
      <div class="hero-content text-center">
        <h2 class="display-1 text-uppercase text-light mt-5 mb-0">Shop</h2>

        <nav class="breadcrumb d-flex justify-content-center">
          <a class="breadcrumb-item nav-link" href="#">Home</a>
          <span class="breadcrumb-item active" aria-current="page">Products</span>
        </nav>
      </div>
    </div>
  </section>

  <section id="shop">
    <div class="container padding-medium">
      <div class="row flex-md-row-reverse g-md-5 mb-5">

        <main class="col-md-12 product-store">
          <div class="row">
            <?php if(!empty($products)): ?>
        <?php foreach($products as $p): ?>
            <div class="col-md-6 col-lg-4 my-4">
              <div class="product-item">
                <div class="image-holder" style="width: 100%; height: 100%;">
                  <?php if($p['image']): ?>
                <img src="<?= base_url('uploads/products/'.$p['image']) ?>" class="card-img-top" alt="<?= esc($p['name']) ?>" alt="Books" class="product-image img-fluid">
              <?php else: ?>
                <img src="<?= base_url('uploads/no-image.png') ?>" class="card-img-top" alt="No image">
              <?php endif; ?>
                </div>
                <div class="cart-concern">
                  <div class="cart-button d-flex justify-content-between align-items-center">
                    <a href="<?= base_url('products/'.$p['id']) ?>" class="btn-wrap cart-link d-flex align-items-center text-capitalize fs-6 ">Explore More
                      <i class="icon icon-arrow-io pe-1"></i>
                    </a>
                    <a href="<?= base_url('products/'.$p['id']) ?>" class="view-btn mt-1">
                      <i class="icon icon-screen-full"></i>
                    </a>
                  </div>
                </div>
                <div class="product-detail d-flex justify-content-between align-items-center mt-2">
                  <a href="<?= base_url('products/'.$p['id']) ?>">
                    <h5 class="product-title mb-0">
                      <?= esc($p['name']) ?>
                    </h5>
                  </a>
                  <p class="m-0 fs-5 fw-normal">₹<?= esc($p['price']) ?></p>
                </div>
              </div>
            </div>
            <?php endforeach; ?>
            <?php else: ?>
              <p class="text-center">No products available.</p>
            <?php endif; ?>
          </div>

        </main>
        
      </div>
    </div>
  </section>

  <footer id="footer" class="bg-primary padding-medium">
    <div class="container text-light ">
      <div class="row">
        <div class="col-md-4">
          <div class="footer-menu">
            <img src="images/logo.png" alt="logo">
            <p class="mt-4">Find and Define Your Perfect Beauty</p>
            <div class="social-links mt-4">
              <ul class="d-flex list-unstyled gap-3">
                <li class="social">
                  <a href="#">
                    <iconify-icon class="social-icon text-light fs-4 me-4" icon="ri:facebook-fill"></iconify-icon>
                  </a>
                </li>
                <li class="social">
                  <a href="#">
                    <iconify-icon class="social-icon text-light fs-4 me-4" icon="ri:twitter-fill"></iconify-icon>
                  </a>
                </li>
                <li class="social">
                  <a href="#">
                    <iconify-icon class="social-icon text-light fs-4 me-4" icon="ri:pinterest-fill"></iconify-icon>
                  </a>
                </li>
                <li class="social">
                  <a href="#">
                    <iconify-icon class="social-icon text-light fs-4 me-4" icon="ri:instagram-fill"></iconify-icon>
                  </a>
                </li>
                <li class="social">
                  <a href="#">
                    <iconify-icon class="social-icon text-light fs-4 me-4" icon="ri:youtube-fill"></iconify-icon>
                  </a>
                </li>

              </ul>
            </div>
          </div>
        </div>
        <div class="col-md-2">
          <div class="footer-menu">
            <h6 class="text-uppercase fw-bold text-light mb-4">Quick Links</h6>
            <ul class="menu-list list-unstyled">
              <li class="menu-item">
                <a href="#" class="footer-link">Home</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">About us</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">Offer </a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">Services</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">Conatct Us</a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-md-2">
          <div class="footer-menu">
            <h6 class="text-uppercase fw-bold text-light mb-4">About</h6>
            <ul class="menu-list list-unstyled">
              <li class="menu-item">
                <a href="#" class="footer-link">How It Work</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">Our Packages</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">promotions</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">refer a friend</a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-md-2">
          <div class="footer-menu">
            <h6 class="text-uppercase fw-bold text-light mb-4">Services</h6>
            <ul class="menu-list list-unstyled">
              <li class="menu-item">
                <a href="#" class="footer-link">Payments</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">Shipping</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">Product returns </a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">FAQs</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">Checkout</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">other Issues</a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-md-2">
          <div class="footer-menu">
            <h6 class="text-uppercase fw-bold text-light mb-4">Help Center</h6>
            <ul class="menu-list list-unstyled">
              <li class="menu-item">
                <a href="#" class="footer-link">Payments</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">Shipping</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">Product returns </a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">FAQs</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">Checkout</a>
              </li>
              <li class="menu-item">
                <a href="#" class="footer-link">other Issues</a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </footer>

  <div id="footer-bottom" class="bg-primary">
    <hr class="text-light m-0">
    <div class="container text-light pt-3">
      <div class="row">
        <div class="col-md-6 copyright">
          <p>© 2025 AURA. All rights reserved.</p>
        </div>
        <div class="col-md-6 text-md-end">
          <p>HTML Template by: <a href="https://templatesjungle.com/" target="_blank"
              class="text-light text-decoration-underline"> TemplatesJungle</a> </p>
        </div>
      </div>
    </div>
  </div>


  <script src="<?= base_url() ?>public/js/jquery-1.11.0.min.js"></script>
  <script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/swiper%409/swiper-bundle.min.js"></script>
  <script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/bootstrap%405.3.0-alpha3/dist/js/bootstrap.bundle.min.js"
    integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe"
    crossorigin="anonymous"></script>
  <script src="<?= base_url() ?>public/js/plugins.js"></script>
  <script src="<?= base_url() ?>public/js/script.js"></script>
  <script src="../../code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>
</body>


<!-- Mirrored from demo.templatesjungle.com/aura/shop.html by HTTrack Website Copier/3.x [XR&CO'2014], Fri, 17 Oct 2025 04:04:17 GMT -->
</html>