<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BannerModel;

class Banner extends BaseController
{
    public function index()
    {
        $model = new BannerModel();
        $data['banner'] = $model->findAll();
        return view('admin/banner/index', $data);
    }

    public function create()
    {
        return view('admin/banner/create');
    }

    public function store()
{
    $model = new BannerModel();

    // ---- Single thumbnail ----
    $imageName = null;
    $thumbnail = $this->request->getFile('image');
    if ($thumbnail && $thumbnail->isValid() && !$thumbnail->hasMoved()) {
        $imageName = $thumbnail->getRandomName();
        $thumbnail->move(WRITEPATH.'../uploads/banner', $imageName);
    }

    // ---- Insert data ----
    $model->insert([
        'maintitle' => $this->request->getPost('maintitle'),
        'subtitle' => $this->request->getPost('subtitle'),
        'image' => $imageName
    ]);

    return redirect()->to(base_url('admin/banner'))->with('success', 'Banner added successfully!');
}


    public function edit($id)
    {
        $model = new BannerModel();
        $data['banner'] = $model->find($id);

        return view('admin/banner/edit', $data);
    }

    public function update($id)
    {
        $model = new BannerModel();
        $blog = $model->find($id);

        // ---- Single thumbnail update ----
        $imageName = $blog['image'];
        $img = $this->request->getFile('image');
        if ($img && $img->isValid() && !$img->hasMoved()) {
            if ($imageName && file_exists('uploads/banner/' . $imageName)) {
                unlink('uploads/banner/' . $imageName);
            }
            $imageName = $img->getRandomName();
            $img->move('uploads/banner', $imageName);
        }


        $model->update($id, [
            'maintitle'        => $this->request->getPost('maintitle'),
            'subtitle' => $this->request->getPost('subtitle'),
            'image'       => $imageName
        ]);

        return redirect()->to(base_url('admin/banner'))->with('success', 'Banner updated successfully!');
    }

    public function delete($id)
    {
        $model = new BannerModel();
        $blog = $model->find($id);

        // Delete single thumbnail
        if ($blog && $blog['image'] && file_exists('uploads/banner/' . $blog['image'])) {
            unlink('uploads/banner/' . $blog['image']);
        }


        $model->delete($id);
        return redirect()->to(base_url('admin/banner'))->with('success', 'Banner deleted successfully!');
    }
}
