<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\BlogModel;

class Blog extends BaseController
{
    public function index()
    {
        $model = new BlogModel();
        $data['blogs'] = $model->findAll();
        return view('admin/blog/index', $data);
    }

    public function create()
    {
        return view('admin/blog/create');
    }

    public function store()
{
    $model = new BlogModel();

    // ---- Single thumbnail ----
    $imageName = null;
    $thumbnail = $this->request->getFile('image');
    if ($thumbnail && $thumbnail->isValid() && !$thumbnail->hasMoved()) {
        $imageName = $thumbnail->getRandomName();
        $thumbnail->move(WRITEPATH.'../uploads/blogs', $imageName);
    }

    // ---- Insert data ----
    $model->insert([
        'title' => $this->request->getPost('title'),
        'slug' => $this->request->getPost('slug'),
        'description' => $this->request->getPost('description'),
        'image' => $imageName,
        'summary' => $this->request->getPost('summary')
    ]);

    return redirect()->to(base_url('admin/blog'))->with('success', 'Blog added successfully!');
}


    public function edit($id)
    {
        $model = new BlogModel();
        $data['blog'] = $model->find($id);

        return view('admin/blog/edit', $data);
    }

    public function update($id)
    {
        $model = new BlogModel();
        $blog = $model->find($id);

        // ---- Single thumbnail update ----
        $imageName = $blog['image'];
        $img = $this->request->getFile('image');
        if ($img && $img->isValid() && !$img->hasMoved()) {
            if ($imageName && file_exists('uploads/blogs/' . $imageName)) {
                unlink('uploads/blogs/' . $imageName);
            }
            $imageName = $img->getRandomName();
            $img->move('uploads/blogs', $imageName);
        }


        $model->update($id, [
            'title'        => $this->request->getPost('title'),
            'slug' => $this->request->getPost('slug'),
            'description'       => $this->request->getPost('description'),
            'image'       => $imageName,
            'summary' => $this->request->getPost('summary')
        ]);

        return redirect()->to(base_url('admin/blog'))->with('success', 'Blog updated successfully!');
    }

    public function delete($id)
    {
        $model = new BlogModel();
        $blog = $model->find($id);

        // Delete single thumbnail
        if ($blog && $blog['image'] && file_exists('uploads/blogs/' . $blog['image'])) {
            unlink('uploads/blogs/' . $blog['image']);
        }


        $model->delete($id);
        return redirect()->to(base_url('admin/blog'))->with('success', 'Blog deleted successfully!');
    }
}
