<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;

class Login extends BaseController
{
    public function index()
    {
        return view('admin/login'); // adjust path if needed
    }

    public function auth()
    {
        $username = $this->request->getPost('username');
        $password = $this->request->getPost('password');

        $model = new \App\Models\AdminModel();
        $admin = $model->where('username', $username)->first();

        if ($admin && password_verify($password, $admin['password'])) {
            session()->set([
                'admin_logged_in' => true,
                'adminUsername'   => $admin['username']
            ]);

            return redirect()->to(base_url('admin/dashboard'));
        } else {
            return redirect()->back()->with('error', 'Invalid credentials');
        }
    }

    public function logout()
    {
        // Destroy session
        session()->destroy();

        // Redirect to login page
        return redirect()->to(base_url('admin/login'));
    }

    // Show change password form
    public function changePassword()
    {
        return view('admin/change_password'); // create this view
    }

    // Handle password update
    public function updatePassword()
    {
        $old = $this->request->getPost('old_password');
        $new = $this->request->getPost('new_password');
        $confirm = $this->request->getPost('confirm_password');

        $username = session()->get('adminUsername');

        $model = new \App\Models\AdminModel();
        $admin = $model->where('username', $username)->first();

        if (!$admin || !password_verify($old, $admin['password'])) {
            return redirect()->back()->with('error', 'Old password is incorrect');
        }

        if ($new !== $confirm) {
            return redirect()->back()->with('error', 'New password and confirm password do not match');
        }

        $model->update($admin['id'], ['password' => password_hash($new, PASSWORD_DEFAULT)]);

        return redirect()->back()->with('success', 'Password updated successfully');
    }


}
