<?php

namespace App\Controllers;
use App\Models\ProductModel;
use App\Models\BlogModel;
use App\Models\BannerModel;
use App\Controllers\BaseController;

class Products extends BaseController
{

    public function index()
    {
        helper('text');

        $model = new ProductModel();
        $data['products'] = $model->orderBy('id', 'DESC')->findAll(4);
        
        $model = new BlogModel();
        $data['blogs'] = $model->orderBy('id', 'DESC')->findAll(3);
        
        $model = new BannerModel();
        $data['banner'] = $model->orderBy('id', 'ASC')->findAll();

        return view('frontend/index', $data);
    }

    public function products()
{
    $model = new ProductModel();
    $data['products'] = $model->findAll();

    return view('frontend/products', $data);
}


public function detail($slug)
{
    $model = new \App\Models\ProductModel();

    $product = $model->where('slug', $slug)->first();

    if (!$product) {
        throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound("Product not found");
    }

    return view('frontend/product-details', ['product' => $product]);
}


}
