<!DOCTYPE html>
<html lang="en">

<head>
  <title>Evason Profumo</title>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="format-detection" content="telephone=no">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="author" content="">
  <meta name="keywords" content="">
  <meta name="description" content="">
</head>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/icomoon/icomoon.css">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet"
  integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/vendor.css">
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/style.css">

<link rel="preconnect" href="https://fonts.googleapis.com/">
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&amp;family=Lustria&amp;display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
<style>
       .sub-banner {
    margin-top: 96px;
}

.breadcrumb a {
    font-size: 16px !important;
}

.breadcrumb-item .active {
    font-size: 16px !important;
}

.about-bg {
    background: #f8d0a0;
}
.padding-normal {
    padding-top: 5rem;
    padding-bottom: 5rem;
}

.expertise-text {
    font-size: 35px !important;
}

.expertise-p {
    font-size: 18px !important;
}

.list-p {
    font-size: 18px !important;
}

</style>
</head>

<body>
    <div class="preloader-wrapper">
        <div class="preloader"></div>
    </div>

    <?php include("header.php"); ?>

    <section class="sub-banner" id="banner">
        <div class="container">
            <div class="hero-content text-center">
                <h2 class="text-uppercase text-light mt-5 mb-0">About Us</h2>
                <nav class="breadcrumb d-flex justify-content-center">
                    <a class="breadcrumb-item nav-link" href="<?php echo base_url(); ?>">Home</a>
                    <span class="breadcrumb-item active" aria-current="page">About Us</span>
                </nav>
            </div>
        </div>
    </section>
    
    
    

    <?php foreach($about as $row): ?>

    <div class="container padding-top">
        <div class="row align-items-center g-md-5">
            <div class="col-md-5">
                <img src="uploads/about/<?= $row['aboutimage']; ?>" alt="img" class="img-fluid">
            </div>
            <div class="col-md-7 mt-5">
                <h2 class="text-black">Who We Are</h2>
                <p><?= $row['about']; ?></p>
                
            </div>
        </div>
        
    </div>
    
    <section class="about-bg">
        <div class="container padding-normal">
            <div class="row mb-3">
                <div class="col-md-6">
                    <h2 class="text-black">Our Mission</h2>
                    <p>To craft world-class fragrances that reflect luxury, innovation, and authenticity, while making them accessible to fragrance lovers around the world.</p>
                    <h4 class="text-black">Core Objectives</h4>
                    <p class="m-0"> <span class="text-primary">✓</span> <b>Crafting exceptional perfumes</b>: Combining creativity, passion, and premium ingredients to deliver unforgettable scent experiences.</p>
                    <p class="m-0"> <span class="text-primary">✓</span> <b>Making luxury accessible</b>: Redefining the meaning of sophistication by offering luxurious fragrances at affordable prices.</p>
                    <p class="m-0"> <span class="text-primary">✓</span> <b>Celebrating identity</b>: Showcasing the beauty and strength of African excellence on a global stage.</p>
                
                </div>
                <div class="col-md-6">
                    <h2 class="text-black">Our Vision</h2>
                    <p>Evason Profumo envisions becoming a globally recognized brand from Nigeria  in the fragrance and beauty industry — a brand that inspires confidence, creativity, and elegance across cultures.</p>
                    <h4 class="text-black">Our Global Vision Includes:</h4>
                    <p class="m-0"> <span class="text-primary">✓</span> <b>Expanding worldwide presence</b>: Introducing Evason Profumo to new markets across the Middle East, Europe, Asia, and beyond.</p>
                    <p class="m-0"> <span class="text-primary">✓</span> <b>Setting new standards</b>: Constantly innovating and redefining what luxury means in modern perfumery.</p>
                    <p class="m-0"> <span class="text-primary">✓</span> <b>Inspiring through style</b>: Transforming imagination into reality with scents that embody sophistication, self-expression, and indulgence.</p>
                    <p class="m-0"> <span class="text-primary">✓</span> <b>Building connections</b>: Creating fragrances that unite people through the universal language of scent.</p>
                </div>
            </div>
    
        </div>
    </section>
  
  
    <section id="register" style="background-image:url(<?= base_url() ?>public/images/about/womens-perfume-glass-tube-pink-background-copy-space-banner-high-quality-photo.jpg); background-repeat: no-repeat; background-position: center; background-size: cover;">
        <div class="container padding-medium" data-aos="fade-up">
            <div class="row banner-content justify-content-center align-items-center">
                <div class="col-md-12">
                    <h2 class="text-black expertise-text">Our Expertise</h2>
                    <div class="">
                        <p class="expertise-p">Evason Profumo's operations are built on creativity, precision, and excellence, covering:</p>
                        <p class="m-0 list-p"> <span class="text-primary">✓</span> Perfume formulation & production</p>
                        <p class="m-0 list-p"> <span class="text-primary">✓</span> 	Sourcing high-quality ingredients</p>
                        <p class="m-0 list-p"> <span class="text-primary">✓</span> 	Branding & marketing</p>
                        <p class="m-0 list-p"> <span class="text-primary">✓</span> 	Distribution & global logistics</p>
                        <p class="m-0 list-p"> <span class="text-primary">✓</span> 	Sales & customer care</p>
                    
                    </div>
                </div>
            </div>
        </div>
    </section>
  
    <div class="container padding-normal">
        <div class="row flex-row-reverse align-items-center g-md-5">
            
            <div class="col-md-12 mt-5">
                <h2 class="text-black">Director's Message </h2>
                <p><?= $row['message']; ?></p>
                  <h4 class="text-black"><?= $row['mfrom']; ?></h4>
                  <h6 class="text-black"><?= $row['designation']; ?></h6>
            
            </div>
        </div>
    </div>
    <?php endforeach; ?>
    
    <div id="blog" class="padding-normal">
        <div class="container" data-aos="fade-up">
            <div class="section-header d-md-flex justify-content-between align-items-center mb-3">
                <h2 class="display-5 fw-light text-uppercase text-black">Recent Blog Post</h2>
                <div>
                  <a href="<?php echo base_url('blogs'); ?>" class="btn btn-primary">
                    Read All</a>
                </div>
            </div>
            <div class="row">
                <?php if(!empty($blogs)): ?>
                <?php foreach($blogs as $b): ?>
                <div class="col-md-4 my-4" data-aos="fade-up" data-aos-delay="300">
                    <div class="card position-relative">
                        <div class="z-1 position-absolute m-2 px-3 pt-1">
                          <h2 class="text-light display-4 m-0">20<span class="fs-4">MAR</span> </h2>
                        </div>
                        <a href="<?= base_url('blog/'.$b['slug']) ?>"><img src="<?= base_url('uploads/blogs/'.$b['image']) ?>" class="img-fluid" alt="Summer skincare routine"></a>
                        <div class="card-body p-0">
                          <a href="<?= base_url('blog/'.$b['slug']) ?>">
                            <h3 class="pt-4 pb-3 m-0 text-black"><?= esc($b['title']) ?></h3>
                          </a>
                          <div class="card-text">
                            <p><?= esc($b['summary']) ?></p>
                          </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
                <?php else: ?>
                <p class="text-center"></p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php include("footer.php"); ?>


<script src="<?= base_url() ?>public/js/jquery-1.11.0.min.js"></script>
<script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/swiper%409/swiper-bundle.min.js"></script>
<script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/bootstrap%405.3.0-alpha3/dist/js/bootstrap.bundle.min.js"
integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe"
crossorigin="anonymous"></script>
<script src="<?= base_url() ?>public/js/plugins.js"></script>
<script src="<?= base_url() ?>public/js/script.js"></script>
<script src="../../code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>

</body>
</html>