<!DOCTYPE html>
<html lang="en">

<head>
  <title>Evason Profumo</title>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="format-detection" content="telephone=no">
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="author" content="">
  <meta name="keywords" content="">
  <meta name="description" content="">
</head>

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/icomoon/icomoon.css">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet"
  integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">

<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/vendor.css">
<link rel="stylesheet" type="text/css" href="<?= base_url() ?>public/css/style.css">

<link rel="preconnect" href="https://fonts.googleapis.com/">
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&amp;family=Lustria&amp;display=swap" rel="stylesheet">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  
  <style>
      .post-thumbnail {
          text-align: center;
      }
  </style>
    <style>
       .sub-banner {
    margin-top: 96px;
}

.breadcrumb a {
    font-size: 16px !important;
}

.breadcrumb-item .active {
    font-size: 16px !important;
}
  </style>
</head>

<body>

  <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
    <defs>
      <symbol xmlns="http://www.w3.org/2000/svg" id="link" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M12 19a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm5 0a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm0-4a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm-5 0a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm7-12h-1V2a1 1 0 0 0-2 0v1H8V2a1 1 0 0 0-2 0v1H5a3 3 0 0 0-3 3v14a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3V6a3 3 0 0 0-3-3Zm1 17a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-9h16Zm0-11H4V6a1 1 0 0 1 1-1h1v1a1 1 0 0 0 2 0V5h8v1a1 1 0 0 0 2 0V5h1a1 1 0 0 1 1 1ZM7 15a1 1 0 1 0-1-1a1 1 0 0 0 1 1Zm0 4a1 1 0 1 0-1-1a1 1 0 0 0 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="arrow-right" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M17.92 11.62a1 1 0 0 0-.21-.33l-5-5a1 1 0 0 0-1.42 1.42l3.3 3.29H7a1 1 0 0 0 0 2h7.59l-3.3 3.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l5-5a1 1 0 0 0 .21-.33a1 1 0 0 0 0-.76Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="category" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M19 5.5h-6.28l-.32-1a3 3 0 0 0-2.84-2H5a3 3 0 0 0-3 3v13a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3v-10a3 3 0 0 0-3-3Zm1 13a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-13a1 1 0 0 1 1-1h4.56a1 1 0 0 1 .95.68l.54 1.64a1 1 0 0 0 .95.68h7a1 1 0 0 1 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="calendar" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M19 4h-2V3a1 1 0 0 0-2 0v1H9V3a1 1 0 0 0-2 0v1H5a3 3 0 0 0-3 3v12a3 3 0 0 0 3 3h14a3 3 0 0 0 3-3V7a3 3 0 0 0-3-3Zm1 15a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-7h16Zm0-9H4V7a1 1 0 0 1 1-1h2v1a1 1 0 0 0 2 0V6h6v1a1 1 0 0 0 2 0V6h2a1 1 0 0 1 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="heart" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M20.16 4.61A6.27 6.27 0 0 0 12 4a6.27 6.27 0 0 0-8.16 9.48l7.45 7.45a1 1 0 0 0 1.42 0l7.45-7.45a6.27 6.27 0 0 0 0-8.87Zm-1.41 7.46L12 18.81l-6.75-6.74a4.28 4.28 0 0 1 3-7.3a4.25 4.25 0 0 1 3 1.25a1 1 0 0 0 1.42 0a4.27 4.27 0 0 1 6 6.05Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="plus" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M19 11h-6V5a1 1 0 0 0-2 0v6H5a1 1 0 0 0 0 2h6v6a1 1 0 0 0 2 0v-6h6a1 1 0 0 0 0-2Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="minus" viewBox="0 0 24 24">
        <path fill="currentColor" d="M19 11H5a1 1 0 0 0 0 2h14a1 1 0 0 0 0-2Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="cart" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M8.5 19a1.5 1.5 0 1 0 1.5 1.5A1.5 1.5 0 0 0 8.5 19ZM19 16H7a1 1 0 0 1 0-2h8.491a3.013 3.013 0 0 0 2.885-2.176l1.585-5.55A1 1 0 0 0 19 5H6.74a3.007 3.007 0 0 0-2.82-2H3a1 1 0 0 0 0 2h.921a1.005 1.005 0 0 1 .962.725l.155.545v.005l1.641 5.742A3 3 0 0 0 7 18h12a1 1 0 0 0 0-2Zm-1.326-9l-1.22 4.274a1.005 1.005 0 0 1-.963.726H8.754l-.255-.892L7.326 7ZM16.5 19a1.5 1.5 0 1 0 1.5 1.5a1.5 1.5 0 0 0-1.5-1.5Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="check" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M18.71 7.21a1 1 0 0 0-1.42 0l-7.45 7.46l-3.13-3.14A1 1 0 1 0 5.29 13l3.84 3.84a1 1 0 0 0 1.42 0l8.16-8.16a1 1 0 0 0 0-1.47Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="trash" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M10 18a1 1 0 0 0 1-1v-6a1 1 0 0 0-2 0v6a1 1 0 0 0 1 1ZM20 6h-4V5a3 3 0 0 0-3-3h-2a3 3 0 0 0-3 3v1H4a1 1 0 0 0 0 2h1v11a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V8h1a1 1 0 0 0 0-2ZM10 5a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v1h-4Zm7 14a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1V8h10Zm-3-1a1 1 0 0 0 1-1v-6a1 1 0 0 0-2 0v6a1 1 0 0 0 1 1Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="star-outline" viewBox="0 0 15 15">
        <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
          d="M7.5 9.804L5.337 11l.413-2.533L4 6.674l2.418-.37L7.5 4l1.082 2.304l2.418.37l-1.75 1.793L9.663 11L7.5 9.804Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="star-solid" viewBox="0 0 15 15">
        <path fill="currentColor"
          d="M7.953 3.788a.5.5 0 0 0-.906 0L6.08 5.85l-2.154.33a.5.5 0 0 0-.283.843l1.574 1.613l-.373 2.284a.5.5 0 0 0 .736.518l1.92-1.063l1.921 1.063a.5.5 0 0 0 .736-.519l-.373-2.283l1.574-1.613a.5.5 0 0 0-.283-.844L8.921 5.85l-.968-2.062Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="search" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M21.71 20.29L18 16.61A9 9 0 1 0 16.61 18l3.68 3.68a1 1 0 0 0 1.42 0a1 1 0 0 0 0-1.39ZM11 18a7 7 0 1 1 7-7a7 7 0 0 1-7 7Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="user" viewBox="0 0 24 24">
        <path fill="currentColor"
          d="M15.71 12.71a6 6 0 1 0-7.42 0a10 10 0 0 0-6.22 8.18a1 1 0 0 0 2 .22a8 8 0 0 1 15.9 0a1 1 0 0 0 1 .89h.11a1 1 0 0 0 .88-1.1a10 10 0 0 0-6.25-8.19ZM12 12a4 4 0 1 1 4-4a4 4 0 0 1-4 4Z" />
      </symbol>
      <symbol xmlns="http://www.w3.org/2000/svg" id="close" viewBox="0 0 15 15">
        <path fill="currentColor"
          d="M7.953 3.788a.5.5 0 0 0-.906 0L6.08 5.85l-2.154.33a.5.5 0 0 0-.283.843l1.574 1.613l-.373 2.284a.5.5 0 0 0 .736.518l1.92-1.063l1.921 1.063a.5.5 0 0 0 .736-.519l-.373-2.283l1.574-1.613a.5.5 0 0 0-.283-.844L8.921 5.85l-.968-2.062Z" />
      </symbol>

    </defs>
  </svg>

  <div class="preloader-wrapper">
    <div class="preloader">
    </div>
  </div>

  <nav class="main-menu navbar fixed-top navbar-expand-lg shadow-sm">
        <div class="container">
            <div class="main-logo d-lg-none">
                <a href="<?php echo base_url(); ?>">
                  <img src="../public/images/logo.png" alt="logo" class="img-fluid">
                </a>
            </div>
            <button class="navbar-toggler border-0 shadow-none " type="button" data-bs-toggle="offcanvas"
            data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar">
            <span class="navbar-toggler-icon"></span>
            </button>

            <div class="offcanvas offcanvas-end bg-black" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel">

                <div class="offcanvas-header justify-content-center">
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                </div>
                <div class="offcanvas-body justify-content-between align-items-center">
                    <div class="main-logo">
                        <a href="<?php echo base_url(); ?>">
                          <img src="../public/images/logo.png" alt="logo" class="img-fluid">
                        </a>
                    </div>
                    <ul class="navbar-nav menu-list list-unstyled d-flex gap-md-3 ps-lg-5 mb-0">
                        <li class="nav-item">
                          <a href="<?php echo base_url(); ?>" class="nav-link mx-2 active">Home</a>
                        </li>
                        <li class="nav-item">
                          <a href="<?php echo base_url('about'); ?>" class="nav-link mx-2">About Us</a>
                        </li>
                        <li class="nav-item">
                          <a href="<?php echo base_url('products'); ?>" class="nav-link mx-2">Products</a>
                        </li>
                        <li class="nav-item">
                          <a href="<?php echo base_url('media'); ?>" class="nav-link mx-2">Media</a>
                        </li>
                        <li class="nav-item">
                          <a href="<?php echo base_url('blogs'); ?>" class="nav-link mx-2">Blog</a>
                        </li>
            
                        <li class="nav-item">
                          <a href="<?php echo base_url('contact-us'); ?>" class="nav-link mx-2">Contact</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </nav>

    <section class="sub-banner" id="banner">
        <div class="container">
            <div class="hero-content text-center">
                <h2 class="text-uppercase text-light mt-5 mb-0">Blog in Detail</h2>
                <nav class="breadcrumb d-flex justify-content-center">
                    <a class="breadcrumb-item nav-link" href="<?php echo base_url(); ?>">Home</a>
                    <span class="breadcrumb-item active" aria-current="page">Blog in Detail</span>
                </nav>
            </div>
        </div>
    </section>

    <section id="single-post">
        <div class="container padding-medium">
            <div class="row">
                <main class="post-grid">
                    <div class="row">
                        <article class="post-item">
                            <div class="post-content">
                                <h2 class="display-5 fw-light text-uppercase mb-5 text-center"><?= esc($blog['title']) ?></h2>
                            
                                <div class="post-thumbnail">
                                    <?php if (!empty($blog['image'])): ?>
                                    <img src="<?= base_url('uploads/blogs/'.$blog['image']) ?>" 
                                     class="img-fluid mb-4" alt="<?= esc($blog['title']) ?>">
                                    <?php endif; ?>
                                </div>
                                <div class="post-description py-4">
                                  <p><?= nl2br($blog['description']) ?></p>
                                </div>
                            </div>
                        </article>
                    </div>
                </main>
            </div>
        </div>
    </section>
  
    <?php if (!empty($latestBlogs)): ?>
    <div id="blog" class="padding-medium pt-0">
        <div class="container">
            <div class="section-header justify-content-between align-items-center mb-3">
                <h2 class="display-5 fw-light text-uppercase">Recent Blog Post</h2>
            </div>
            <div class="row">
                <?php foreach ($latestBlogs as $lb): ?>
                <div class="col-md-4 my-4">
                    <div class="z-1 position-absolute m-2 px-3 pt-1">
                        <?php
                        $date = date_create($lb['created_at']);
                        $day = date_format($date, 'd');
                        $month = strtoupper(date_format($date, 'M'));
                        ?>
                        <h2 class="text-light display-4 m-0"><?= $day ?><span class="fs-4"><?= $month ?></span></h2>
                
                    </div>
                    <div class="card position-relative ">
                        <a href="<?= base_url('blog/'.$lb['slug']) ?>"><?php if (!empty($lb['image'])): ?>
                        <img src="<?= base_url('uploads/blogs/'.$lb['image']) ?>" class="img-fluid rounded mb-2" alt="<?= esc($lb['title']) ?>">
                        <?php endif; ?></a>
                        <div class="card-body p-0">
                            <a href="<?= base_url('blog/'.$lb['slug']) ?>">
                            <h3 class="pt-4 pb-3 m-0"><?= esc($lb['title']) ?></h3>
                            </a>
                            <div class="card-text">
                                <p><?= esc($lb['summary']) ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <footer id="footer" class="bg-primary padding-footer">
    <div class="container text-light ">
        <div class="row">
            <div class="col-md-5">
                <div class="footer-menu">
                    <img src="../public/images/logo.png" alt="logo">
                    <p class="mt-4">Find and Define Your Perfect Beauty</p>
                    <div class="social-links mt-4"></div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="footer-menu">
                    <h6 class="text-uppercase fw-bold text-light mb-4">Quick Links</h6>
                    <ul class="menu-list list-unstyled">
                        <li class="menu-item"><a href="<?php echo base_url(); ?>" class="footer-link">Home</a></li>
                        <li class="menu-item"><a href="<?php echo base_url('about'); ?>" class="footer-link">About us</a></li>
                        <li class="menu-item"><a href="<?php echo base_url('products'); ?>" class="footer-link">Products </a></li>
                        <li class="menu-item"><a href="<?php echo base_url('media'); ?>" class="footer-link">Media</a></li>
                        <li class="menu-item"><a href="<?php echo base_url('blogs'); ?>" class="footer-link">Blogs</a></li>
                        <li class="menu-item"><a href="<?php echo base_url('contact-us'); ?>" class="footer-link">Conatct Us</a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4">
                <div class="footer-menu">
                    <h6 class="text-uppercase fw-bold text-light mb-4">Contact Info</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2"><i class="fas fa-map-marker-alt me-2"></i>No. 6 Onne Road, GRA Phase 2, <br> Port Harcourt, Rivers State, Nigeria</li>
                        
                        <li class="mb-2"><i class="fas fa-phone me-2"></i><a href="tel:+2348161185456" class="text-light text-decoration-none">+234 816 118 5456</a></li>
                        
                        <li class="mb-2"><i class="fas fa-envelope me-2"></i><a href="mailto:evasoncosmetics@gmail.com" class="text-light text-decoration-none">evasoncosmetics@gmail.com</a></li>
                    </ul>
                    <ul class="d-flex list-unstyled gap-3">
                        <li class="social">
                          <a href="#">
                            <iconify-icon class="social-icon text-light fs-4 me-4" icon="ri:facebook-fill"></iconify-icon>
                          </a>
                        </li>
                        <li class="social">
                          <a href="#">
                            <iconify-icon class="social-icon text-light fs-4 me-4" icon="ri:twitter-fill"></iconify-icon>
                          </a>
                        </li>
                        <li class="social">
                          <a href="#">
                            <iconify-icon class="social-icon text-light fs-4 me-4" icon="ri:pinterest-fill"></iconify-icon>
                          </a>
                        </li>
                        <li class="social">
                          <a href="#">
                            <iconify-icon class="social-icon text-light fs-4 me-4" icon="ri:instagram-fill"></iconify-icon>
                          </a>
                        </li>
                        <li class="social">
                          <a href="#">
                            <iconify-icon class="social-icon text-light fs-4 me-4" icon="ri:youtube-fill"></iconify-icon>
                          </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>
<div id="footer-bottom" class="bg-primary">
    <hr class="text-light m-0">
    <div class="container text-light pt-3">
        <div class="row">
            <div class="col-md-12 copyright">
                <p>© 2025 Evason Profumo. All rights reserved.</p>
            </div>
        </div>
    </div>
</div>

<script src="<?= base_url() ?>public/js/jquery-1.11.0.min.js"></script>
<script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/swiper%409/swiper-bundle.min.js"></script>
<script src="<?= base_url() ?>public/cdn.jsdelivr.net/npm/bootstrap%405.3.0-alpha3/dist/js/bootstrap.bundle.min.js"
integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe"
crossorigin="anonymous"></script>
<script src="<?= base_url() ?>public/js/plugins.js"></script>
<script src="<?= base_url() ?>public/js/script.js"></script>
<script src="<?= base_url() ?>public/code.iconify.design/iconify-icon/1.0.7/iconify-icon.min.js"></script>

</body>
</html>